
/*
 *  Color manipulation
 *
 *  (C) Copyright 2001-2003 Geert Uytterhoeven
 *
 *  This file is subject to the terms and conditions of the GNU General Public
 *  License. See the file COPYING in the main directory of this archive for
 *  more details.
 */

#include <stdlib.h>

#include "types.h"
#include "color.h"


    /*
     *  Relative weight RGB versus alpha
     */

#define RGB_WEIGHT	4


    /*
     *  X11 colors from rgb.txt
     */

const rgba_t c_snow = { 0xffff, 0xfafa, 0xfafa, 0xffff };
const rgba_t c_ghost_white = { 0xf8f8, 0xf8f8, 0xffff, 0xffff };
const rgba_t c_GhostWhite = { 0xf8f8, 0xf8f8, 0xffff, 0xffff };
const rgba_t c_white_smoke = { 0xf5f5, 0xf5f5, 0xf5f5, 0xffff };
const rgba_t c_WhiteSmoke = { 0xf5f5, 0xf5f5, 0xf5f5, 0xffff };
const rgba_t c_gainsboro = { 0xdcdc, 0xdcdc, 0xdcdc, 0xffff };
const rgba_t c_floral_white = { 0xffff, 0xfafa, 0xf0f0, 0xffff };
const rgba_t c_FloralWhite = { 0xffff, 0xfafa, 0xf0f0, 0xffff };
const rgba_t c_old_lace = { 0xfdfd, 0xf5f5, 0xe6e6, 0xffff };
const rgba_t c_OldLace = { 0xfdfd, 0xf5f5, 0xe6e6, 0xffff };
const rgba_t c_linen = { 0xfafa, 0xf0f0, 0xe6e6, 0xffff };
const rgba_t c_antique_white = { 0xfafa, 0xebeb, 0xd7d7, 0xffff };
const rgba_t c_AntiqueWhite = { 0xfafa, 0xebeb, 0xd7d7, 0xffff };
const rgba_t c_papaya_whip = { 0xffff, 0xefef, 0xd5d5, 0xffff };
const rgba_t c_PapayaWhip = { 0xffff, 0xefef, 0xd5d5, 0xffff };
const rgba_t c_blanched_almond = { 0xffff, 0xebeb, 0xcdcd, 0xffff };
const rgba_t c_BlanchedAlmond = { 0xffff, 0xebeb, 0xcdcd, 0xffff };
const rgba_t c_bisque = { 0xffff, 0xe4e4, 0xc4c4, 0xffff };
const rgba_t c_peach_puff = { 0xffff, 0xdada, 0xb9b9, 0xffff };
const rgba_t c_PeachPuff = { 0xffff, 0xdada, 0xb9b9, 0xffff };
const rgba_t c_navajo_white = { 0xffff, 0xdede, 0xadad, 0xffff };
const rgba_t c_NavajoWhite = { 0xffff, 0xdede, 0xadad, 0xffff };
const rgba_t c_moccasin = { 0xffff, 0xe4e4, 0xb5b5, 0xffff };
const rgba_t c_cornsilk = { 0xffff, 0xf8f8, 0xdcdc, 0xffff };
const rgba_t c_ivory = { 0xffff, 0xffff, 0xf0f0, 0xffff };
const rgba_t c_lemon_chiffon = { 0xffff, 0xfafa, 0xcdcd, 0xffff };
const rgba_t c_LemonChiffon = { 0xffff, 0xfafa, 0xcdcd, 0xffff };
const rgba_t c_seashell = { 0xffff, 0xf5f5, 0xeeee, 0xffff };
const rgba_t c_honeydew = { 0xf0f0, 0xffff, 0xf0f0, 0xffff };
const rgba_t c_mint_cream = { 0xf5f5, 0xffff, 0xfafa, 0xffff };
const rgba_t c_MintCream = { 0xf5f5, 0xffff, 0xfafa, 0xffff };
const rgba_t c_azure = { 0xf0f0, 0xffff, 0xffff, 0xffff };
const rgba_t c_alice_blue = { 0xf0f0, 0xf8f8, 0xffff, 0xffff };
const rgba_t c_AliceBlue = { 0xf0f0, 0xf8f8, 0xffff, 0xffff };
const rgba_t c_lavender = { 0xe6e6, 0xe6e6, 0xfafa, 0xffff };
const rgba_t c_lavender_blush = { 0xffff, 0xf0f0, 0xf5f5, 0xffff };
const rgba_t c_LavenderBlush = { 0xffff, 0xf0f0, 0xf5f5, 0xffff };
const rgba_t c_misty_rose = { 0xffff, 0xe4e4, 0xe1e1, 0xffff };
const rgba_t c_MistyRose = { 0xffff, 0xe4e4, 0xe1e1, 0xffff };
const rgba_t c_white = { 0xffff, 0xffff, 0xffff, 0xffff };
const rgba_t c_black = { 0x0000, 0x0000, 0x0000, 0xffff };
const rgba_t c_dark_slate_gray = { 0x2f2f, 0x4f4f, 0x4f4f, 0xffff };
const rgba_t c_DarkSlateGray = { 0x2f2f, 0x4f4f, 0x4f4f, 0xffff };
const rgba_t c_dark_slate_grey = { 0x2f2f, 0x4f4f, 0x4f4f, 0xffff };
const rgba_t c_DarkSlateGrey = { 0x2f2f, 0x4f4f, 0x4f4f, 0xffff };
const rgba_t c_dim_gray = { 0x6969, 0x6969, 0x6969, 0xffff };
const rgba_t c_DimGray = { 0x6969, 0x6969, 0x6969, 0xffff };
const rgba_t c_dim_grey = { 0x6969, 0x6969, 0x6969, 0xffff };
const rgba_t c_DimGrey = { 0x6969, 0x6969, 0x6969, 0xffff };
const rgba_t c_slate_gray = { 0x7070, 0x8080, 0x9090, 0xffff };
const rgba_t c_SlateGray = { 0x7070, 0x8080, 0x9090, 0xffff };
const rgba_t c_slate_grey = { 0x7070, 0x8080, 0x9090, 0xffff };
const rgba_t c_SlateGrey = { 0x7070, 0x8080, 0x9090, 0xffff };
const rgba_t c_light_slate_gray = { 0x7777, 0x8888, 0x9999, 0xffff };
const rgba_t c_LightSlateGray = { 0x7777, 0x8888, 0x9999, 0xffff };
const rgba_t c_light_slate_grey = { 0x7777, 0x8888, 0x9999, 0xffff };
const rgba_t c_LightSlateGrey = { 0x7777, 0x8888, 0x9999, 0xffff };
const rgba_t c_gray = { 0xbebe, 0xbebe, 0xbebe, 0xffff };
const rgba_t c_grey = { 0xbebe, 0xbebe, 0xbebe, 0xffff };
const rgba_t c_light_grey = { 0xd3d3, 0xd3d3, 0xd3d3, 0xffff };
const rgba_t c_LightGrey = { 0xd3d3, 0xd3d3, 0xd3d3, 0xffff };
const rgba_t c_light_gray = { 0xd3d3, 0xd3d3, 0xd3d3, 0xffff };
const rgba_t c_LightGray = { 0xd3d3, 0xd3d3, 0xd3d3, 0xffff };
const rgba_t c_midnight_blue = { 0x1919, 0x1919, 0x7070, 0xffff };
const rgba_t c_MidnightBlue = { 0x1919, 0x1919, 0x7070, 0xffff };
const rgba_t c_navy = { 0x0000, 0x0000, 0x8080, 0xffff };
const rgba_t c_navy_blue = { 0x0000, 0x0000, 0x8080, 0xffff };
const rgba_t c_NavyBlue = { 0x0000, 0x0000, 0x8080, 0xffff };
const rgba_t c_cornflower_blue = { 0x6464, 0x9595, 0xeded, 0xffff };
const rgba_t c_CornflowerBlue = { 0x6464, 0x9595, 0xeded, 0xffff };
const rgba_t c_dark_slate_blue = { 0x4848, 0x3d3d, 0x8b8b, 0xffff };
const rgba_t c_DarkSlateBlue = { 0x4848, 0x3d3d, 0x8b8b, 0xffff };
const rgba_t c_slate_blue = { 0x6a6a, 0x5a5a, 0xcdcd, 0xffff };
const rgba_t c_SlateBlue = { 0x6a6a, 0x5a5a, 0xcdcd, 0xffff };
const rgba_t c_medium_slate_blue = { 0x7b7b, 0x6868, 0xeeee, 0xffff };
const rgba_t c_MediumSlateBlue = { 0x7b7b, 0x6868, 0xeeee, 0xffff };
const rgba_t c_light_slate_blue = { 0x8484, 0x7070, 0xffff, 0xffff };
const rgba_t c_LightSlateBlue = { 0x8484, 0x7070, 0xffff, 0xffff };
const rgba_t c_medium_blue = { 0x0000, 0x0000, 0xcdcd, 0xffff };
const rgba_t c_MediumBlue = { 0x0000, 0x0000, 0xcdcd, 0xffff };
const rgba_t c_royal_blue = { 0x4141, 0x6969, 0xe1e1, 0xffff };
const rgba_t c_RoyalBlue = { 0x4141, 0x6969, 0xe1e1, 0xffff };
const rgba_t c_blue = { 0x0000, 0x0000, 0xffff, 0xffff };
const rgba_t c_dodger_blue = { 0x1e1e, 0x9090, 0xffff, 0xffff };
const rgba_t c_DodgerBlue = { 0x1e1e, 0x9090, 0xffff, 0xffff };
const rgba_t c_deep_sky_blue = { 0x0000, 0xbfbf, 0xffff, 0xffff };
const rgba_t c_DeepSkyBlue = { 0x0000, 0xbfbf, 0xffff, 0xffff };
const rgba_t c_sky_blue = { 0x8787, 0xcece, 0xebeb, 0xffff };
const rgba_t c_SkyBlue = { 0x8787, 0xcece, 0xebeb, 0xffff };
const rgba_t c_light_sky_blue = { 0x8787, 0xcece, 0xfafa, 0xffff };
const rgba_t c_LightSkyBlue = { 0x8787, 0xcece, 0xfafa, 0xffff };
const rgba_t c_steel_blue = { 0x4646, 0x8282, 0xb4b4, 0xffff };
const rgba_t c_SteelBlue = { 0x4646, 0x8282, 0xb4b4, 0xffff };
const rgba_t c_light_steel_blue = { 0xb0b0, 0xc4c4, 0xdede, 0xffff };
const rgba_t c_LightSteelBlue = { 0xb0b0, 0xc4c4, 0xdede, 0xffff };
const rgba_t c_light_blue = { 0xadad, 0xd8d8, 0xe6e6, 0xffff };
const rgba_t c_LightBlue = { 0xadad, 0xd8d8, 0xe6e6, 0xffff };
const rgba_t c_powder_blue = { 0xb0b0, 0xe0e0, 0xe6e6, 0xffff };
const rgba_t c_PowderBlue = { 0xb0b0, 0xe0e0, 0xe6e6, 0xffff };
const rgba_t c_pale_turquoise = { 0xafaf, 0xeeee, 0xeeee, 0xffff };
const rgba_t c_PaleTurquoise = { 0xafaf, 0xeeee, 0xeeee, 0xffff };
const rgba_t c_dark_turquoise = { 0x0000, 0xcece, 0xd1d1, 0xffff };
const rgba_t c_DarkTurquoise = { 0x0000, 0xcece, 0xd1d1, 0xffff };
const rgba_t c_medium_turquoise = { 0x4848, 0xd1d1, 0xcccc, 0xffff };
const rgba_t c_MediumTurquoise = { 0x4848, 0xd1d1, 0xcccc, 0xffff };
const rgba_t c_turquoise = { 0x4040, 0xe0e0, 0xd0d0, 0xffff };
const rgba_t c_cyan = { 0x0000, 0xffff, 0xffff, 0xffff };
const rgba_t c_light_cyan = { 0xe0e0, 0xffff, 0xffff, 0xffff };
const rgba_t c_LightCyan = { 0xe0e0, 0xffff, 0xffff, 0xffff };
const rgba_t c_cadet_blue = { 0x5f5f, 0x9e9e, 0xa0a0, 0xffff };
const rgba_t c_CadetBlue = { 0x5f5f, 0x9e9e, 0xa0a0, 0xffff };
const rgba_t c_medium_aquamarine = { 0x6666, 0xcdcd, 0xaaaa, 0xffff };
const rgba_t c_MediumAquamarine = { 0x6666, 0xcdcd, 0xaaaa, 0xffff };
const rgba_t c_aquamarine = { 0x7f7f, 0xffff, 0xd4d4, 0xffff };
const rgba_t c_dark_green = { 0x0000, 0x6464, 0x0000, 0xffff };
const rgba_t c_DarkGreen = { 0x0000, 0x6464, 0x0000, 0xffff };
const rgba_t c_dark_olive_green = { 0x5555, 0x6b6b, 0x2f2f, 0xffff };
const rgba_t c_DarkOliveGreen = { 0x5555, 0x6b6b, 0x2f2f, 0xffff };
const rgba_t c_dark_sea_green = { 0x8f8f, 0xbcbc, 0x8f8f, 0xffff };
const rgba_t c_DarkSeaGreen = { 0x8f8f, 0xbcbc, 0x8f8f, 0xffff };
const rgba_t c_sea_green = { 0x2e2e, 0x8b8b, 0x5757, 0xffff };
const rgba_t c_SeaGreen = { 0x2e2e, 0x8b8b, 0x5757, 0xffff };
const rgba_t c_medium_sea_green = { 0x3c3c, 0xb3b3, 0x7171, 0xffff };
const rgba_t c_MediumSeaGreen = { 0x3c3c, 0xb3b3, 0x7171, 0xffff };
const rgba_t c_light_sea_green = { 0x2020, 0xb2b2, 0xaaaa, 0xffff };
const rgba_t c_LightSeaGreen = { 0x2020, 0xb2b2, 0xaaaa, 0xffff };
const rgba_t c_pale_green = { 0x9898, 0xfbfb, 0x9898, 0xffff };
const rgba_t c_PaleGreen = { 0x9898, 0xfbfb, 0x9898, 0xffff };
const rgba_t c_spring_green = { 0x0000, 0xffff, 0x7f7f, 0xffff };
const rgba_t c_SpringGreen = { 0x0000, 0xffff, 0x7f7f, 0xffff };
const rgba_t c_lawn_green = { 0x7c7c, 0xfcfc, 0x0000, 0xffff };
const rgba_t c_LawnGreen = { 0x7c7c, 0xfcfc, 0x0000, 0xffff };
const rgba_t c_green = { 0x0000, 0xffff, 0x0000, 0xffff };
const rgba_t c_chartreuse = { 0x7f7f, 0xffff, 0x0000, 0xffff };
const rgba_t c_medium_spring_green = { 0x0000, 0xfafa, 0x9a9a, 0xffff };
const rgba_t c_MediumSpringGreen = { 0x0000, 0xfafa, 0x9a9a, 0xffff };
const rgba_t c_green_yellow = { 0xadad, 0xffff, 0x2f2f, 0xffff };
const rgba_t c_GreenYellow = { 0xadad, 0xffff, 0x2f2f, 0xffff };
const rgba_t c_lime_green = { 0x3232, 0xcdcd, 0x3232, 0xffff };
const rgba_t c_LimeGreen = { 0x3232, 0xcdcd, 0x3232, 0xffff };
const rgba_t c_yellow_green = { 0x9a9a, 0xcdcd, 0x3232, 0xffff };
const rgba_t c_YellowGreen = { 0x9a9a, 0xcdcd, 0x3232, 0xffff };
const rgba_t c_forest_green = { 0x2222, 0x8b8b, 0x2222, 0xffff };
const rgba_t c_ForestGreen = { 0x2222, 0x8b8b, 0x2222, 0xffff };
const rgba_t c_olive_drab = { 0x6b6b, 0x8e8e, 0x2323, 0xffff };
const rgba_t c_OliveDrab = { 0x6b6b, 0x8e8e, 0x2323, 0xffff };
const rgba_t c_dark_khaki = { 0xbdbd, 0xb7b7, 0x6b6b, 0xffff };
const rgba_t c_DarkKhaki = { 0xbdbd, 0xb7b7, 0x6b6b, 0xffff };
const rgba_t c_khaki = { 0xf0f0, 0xe6e6, 0x8c8c, 0xffff };
const rgba_t c_pale_goldenrod = { 0xeeee, 0xe8e8, 0xaaaa, 0xffff };
const rgba_t c_PaleGoldenrod = { 0xeeee, 0xe8e8, 0xaaaa, 0xffff };
const rgba_t c_light_goldenrod_yellow = { 0xfafa, 0xfafa, 0xd2d2, 0xffff };
const rgba_t c_LightGoldenrodYellow = { 0xfafa, 0xfafa, 0xd2d2, 0xffff };
const rgba_t c_light_yellow = { 0xffff, 0xffff, 0xe0e0, 0xffff };
const rgba_t c_LightYellow = { 0xffff, 0xffff, 0xe0e0, 0xffff };
const rgba_t c_yellow = { 0xffff, 0xffff, 0x0000, 0xffff };
const rgba_t c_gold = { 0xffff, 0xd7d7, 0x0000, 0xffff };
const rgba_t c_light_goldenrod = { 0xeeee, 0xdddd, 0x8282, 0xffff };
const rgba_t c_LightGoldenrod = { 0xeeee, 0xdddd, 0x8282, 0xffff };
const rgba_t c_goldenrod = { 0xdada, 0xa5a5, 0x2020, 0xffff };
const rgba_t c_dark_goldenrod = { 0xb8b8, 0x8686, 0x0b0b, 0xffff };
const rgba_t c_DarkGoldenrod = { 0xb8b8, 0x8686, 0x0b0b, 0xffff };
const rgba_t c_rosy_brown = { 0xbcbc, 0x8f8f, 0x8f8f, 0xffff };
const rgba_t c_RosyBrown = { 0xbcbc, 0x8f8f, 0x8f8f, 0xffff };
const rgba_t c_indian_red = { 0xcdcd, 0x5c5c, 0x5c5c, 0xffff };
const rgba_t c_IndianRed = { 0xcdcd, 0x5c5c, 0x5c5c, 0xffff };
const rgba_t c_saddle_brown = { 0x8b8b, 0x4545, 0x1313, 0xffff };
const rgba_t c_SaddleBrown = { 0x8b8b, 0x4545, 0x1313, 0xffff };
const rgba_t c_sienna = { 0xa0a0, 0x5252, 0x2d2d, 0xffff };
const rgba_t c_peru = { 0xcdcd, 0x8585, 0x3f3f, 0xffff };
const rgba_t c_burlywood = { 0xdede, 0xb8b8, 0x8787, 0xffff };
const rgba_t c_beige = { 0xf5f5, 0xf5f5, 0xdcdc, 0xffff };
const rgba_t c_wheat = { 0xf5f5, 0xdede, 0xb3b3, 0xffff };
const rgba_t c_sandy_brown = { 0xf4f4, 0xa4a4, 0x6060, 0xffff };
const rgba_t c_SandyBrown = { 0xf4f4, 0xa4a4, 0x6060, 0xffff };
const rgba_t c_tan = { 0xd2d2, 0xb4b4, 0x8c8c, 0xffff };
const rgba_t c_chocolate = { 0xd2d2, 0x6969, 0x1e1e, 0xffff };
const rgba_t c_firebrick = { 0xb2b2, 0x2222, 0x2222, 0xffff };
const rgba_t c_brown = { 0xa5a5, 0x2a2a, 0x2a2a, 0xffff };
const rgba_t c_dark_salmon = { 0xe9e9, 0x9696, 0x7a7a, 0xffff };
const rgba_t c_DarkSalmon = { 0xe9e9, 0x9696, 0x7a7a, 0xffff };
const rgba_t c_salmon = { 0xfafa, 0x8080, 0x7272, 0xffff };
const rgba_t c_light_salmon = { 0xffff, 0xa0a0, 0x7a7a, 0xffff };
const rgba_t c_LightSalmon = { 0xffff, 0xa0a0, 0x7a7a, 0xffff };
const rgba_t c_orange = { 0xffff, 0xa5a5, 0x0000, 0xffff };
const rgba_t c_dark_orange = { 0xffff, 0x8c8c, 0x0000, 0xffff };
const rgba_t c_DarkOrange = { 0xffff, 0x8c8c, 0x0000, 0xffff };
const rgba_t c_coral = { 0xffff, 0x7f7f, 0x5050, 0xffff };
const rgba_t c_light_coral = { 0xf0f0, 0x8080, 0x8080, 0xffff };
const rgba_t c_LightCoral = { 0xf0f0, 0x8080, 0x8080, 0xffff };
const rgba_t c_tomato = { 0xffff, 0x6363, 0x4747, 0xffff };
const rgba_t c_orange_red = { 0xffff, 0x4545, 0x0000, 0xffff };
const rgba_t c_OrangeRed = { 0xffff, 0x4545, 0x0000, 0xffff };
const rgba_t c_red = { 0xffff, 0x0000, 0x0000, 0xffff };
const rgba_t c_hot_pink = { 0xffff, 0x6969, 0xb4b4, 0xffff };
const rgba_t c_HotPink = { 0xffff, 0x6969, 0xb4b4, 0xffff };
const rgba_t c_deep_pink = { 0xffff, 0x1414, 0x9393, 0xffff };
const rgba_t c_DeepPink = { 0xffff, 0x1414, 0x9393, 0xffff };
const rgba_t c_pink = { 0xffff, 0xc0c0, 0xcbcb, 0xffff };
const rgba_t c_light_pink = { 0xffff, 0xb6b6, 0xc1c1, 0xffff };
const rgba_t c_LightPink = { 0xffff, 0xb6b6, 0xc1c1, 0xffff };
const rgba_t c_pale_violet_red = { 0xdbdb, 0x7070, 0x9393, 0xffff };
const rgba_t c_PaleVioletRed = { 0xdbdb, 0x7070, 0x9393, 0xffff };
const rgba_t c_maroon = { 0xb0b0, 0x3030, 0x6060, 0xffff };
const rgba_t c_medium_violet_red = { 0xc7c7, 0x1515, 0x8585, 0xffff };
const rgba_t c_MediumVioletRed = { 0xc7c7, 0x1515, 0x8585, 0xffff };
const rgba_t c_violet_red = { 0xd0d0, 0x2020, 0x9090, 0xffff };
const rgba_t c_VioletRed = { 0xd0d0, 0x2020, 0x9090, 0xffff };
const rgba_t c_magenta = { 0xffff, 0x0000, 0xffff, 0xffff };
const rgba_t c_violet = { 0xeeee, 0x8282, 0xeeee, 0xffff };
const rgba_t c_plum = { 0xdddd, 0xa0a0, 0xdddd, 0xffff };
const rgba_t c_orchid = { 0xdada, 0x7070, 0xd6d6, 0xffff };
const rgba_t c_medium_orchid = { 0xbaba, 0x5555, 0xd3d3, 0xffff };
const rgba_t c_MediumOrchid = { 0xbaba, 0x5555, 0xd3d3, 0xffff };
const rgba_t c_dark_orchid = { 0x9999, 0x3232, 0xcccc, 0xffff };
const rgba_t c_DarkOrchid = { 0x9999, 0x3232, 0xcccc, 0xffff };
const rgba_t c_dark_violet = { 0x9494, 0x0000, 0xd3d3, 0xffff };
const rgba_t c_DarkViolet = { 0x9494, 0x0000, 0xd3d3, 0xffff };
const rgba_t c_blue_violet = { 0x8a8a, 0x2b2b, 0xe2e2, 0xffff };
const rgba_t c_BlueViolet = { 0x8a8a, 0x2b2b, 0xe2e2, 0xffff };
const rgba_t c_purple = { 0xa0a0, 0x2020, 0xf0f0, 0xffff };
const rgba_t c_medium_purple = { 0x9393, 0x7070, 0xdbdb, 0xffff };
const rgba_t c_MediumPurple = { 0x9393, 0x7070, 0xdbdb, 0xffff };
const rgba_t c_thistle = { 0xd8d8, 0xbfbf, 0xd8d8, 0xffff };
const rgba_t c_snow1 = { 0xffff, 0xfafa, 0xfafa, 0xffff };
const rgba_t c_snow2 = { 0xeeee, 0xe9e9, 0xe9e9, 0xffff };
const rgba_t c_snow3 = { 0xcdcd, 0xc9c9, 0xc9c9, 0xffff };
const rgba_t c_snow4 = { 0x8b8b, 0x8989, 0x8989, 0xffff };
const rgba_t c_seashell1 = { 0xffff, 0xf5f5, 0xeeee, 0xffff };
const rgba_t c_seashell2 = { 0xeeee, 0xe5e5, 0xdede, 0xffff };
const rgba_t c_seashell3 = { 0xcdcd, 0xc5c5, 0xbfbf, 0xffff };
const rgba_t c_seashell4 = { 0x8b8b, 0x8686, 0x8282, 0xffff };
const rgba_t c_AntiqueWhite1 = { 0xffff, 0xefef, 0xdbdb, 0xffff };
const rgba_t c_AntiqueWhite2 = { 0xeeee, 0xdfdf, 0xcccc, 0xffff };
const rgba_t c_AntiqueWhite3 = { 0xcdcd, 0xc0c0, 0xb0b0, 0xffff };
const rgba_t c_AntiqueWhite4 = { 0x8b8b, 0x8383, 0x7878, 0xffff };
const rgba_t c_bisque1 = { 0xffff, 0xe4e4, 0xc4c4, 0xffff };
const rgba_t c_bisque2 = { 0xeeee, 0xd5d5, 0xb7b7, 0xffff };
const rgba_t c_bisque3 = { 0xcdcd, 0xb7b7, 0x9e9e, 0xffff };
const rgba_t c_bisque4 = { 0x8b8b, 0x7d7d, 0x6b6b, 0xffff };
const rgba_t c_PeachPuff1 = { 0xffff, 0xdada, 0xb9b9, 0xffff };
const rgba_t c_PeachPuff2 = { 0xeeee, 0xcbcb, 0xadad, 0xffff };
const rgba_t c_PeachPuff3 = { 0xcdcd, 0xafaf, 0x9595, 0xffff };
const rgba_t c_PeachPuff4 = { 0x8b8b, 0x7777, 0x6565, 0xffff };
const rgba_t c_NavajoWhite1 = { 0xffff, 0xdede, 0xadad, 0xffff };
const rgba_t c_NavajoWhite2 = { 0xeeee, 0xcfcf, 0xa1a1, 0xffff };
const rgba_t c_NavajoWhite3 = { 0xcdcd, 0xb3b3, 0x8b8b, 0xffff };
const rgba_t c_NavajoWhite4 = { 0x8b8b, 0x7979, 0x5e5e, 0xffff };
const rgba_t c_LemonChiffon1 = { 0xffff, 0xfafa, 0xcdcd, 0xffff };
const rgba_t c_LemonChiffon2 = { 0xeeee, 0xe9e9, 0xbfbf, 0xffff };
const rgba_t c_LemonChiffon3 = { 0xcdcd, 0xc9c9, 0xa5a5, 0xffff };
const rgba_t c_LemonChiffon4 = { 0x8b8b, 0x8989, 0x7070, 0xffff };
const rgba_t c_cornsilk1 = { 0xffff, 0xf8f8, 0xdcdc, 0xffff };
const rgba_t c_cornsilk2 = { 0xeeee, 0xe8e8, 0xcdcd, 0xffff };
const rgba_t c_cornsilk3 = { 0xcdcd, 0xc8c8, 0xb1b1, 0xffff };
const rgba_t c_cornsilk4 = { 0x8b8b, 0x8888, 0x7878, 0xffff };
const rgba_t c_ivory1 = { 0xffff, 0xffff, 0xf0f0, 0xffff };
const rgba_t c_ivory2 = { 0xeeee, 0xeeee, 0xe0e0, 0xffff };
const rgba_t c_ivory3 = { 0xcdcd, 0xcdcd, 0xc1c1, 0xffff };
const rgba_t c_ivory4 = { 0x8b8b, 0x8b8b, 0x8383, 0xffff };
const rgba_t c_honeydew1 = { 0xf0f0, 0xffff, 0xf0f0, 0xffff };
const rgba_t c_honeydew2 = { 0xe0e0, 0xeeee, 0xe0e0, 0xffff };
const rgba_t c_honeydew3 = { 0xc1c1, 0xcdcd, 0xc1c1, 0xffff };
const rgba_t c_honeydew4 = { 0x8383, 0x8b8b, 0x8383, 0xffff };
const rgba_t c_LavenderBlush1 = { 0xffff, 0xf0f0, 0xf5f5, 0xffff };
const rgba_t c_LavenderBlush2 = { 0xeeee, 0xe0e0, 0xe5e5, 0xffff };
const rgba_t c_LavenderBlush3 = { 0xcdcd, 0xc1c1, 0xc5c5, 0xffff };
const rgba_t c_LavenderBlush4 = { 0x8b8b, 0x8383, 0x8686, 0xffff };
const rgba_t c_MistyRose1 = { 0xffff, 0xe4e4, 0xe1e1, 0xffff };
const rgba_t c_MistyRose2 = { 0xeeee, 0xd5d5, 0xd2d2, 0xffff };
const rgba_t c_MistyRose3 = { 0xcdcd, 0xb7b7, 0xb5b5, 0xffff };
const rgba_t c_MistyRose4 = { 0x8b8b, 0x7d7d, 0x7b7b, 0xffff };
const rgba_t c_azure1 = { 0xf0f0, 0xffff, 0xffff, 0xffff };
const rgba_t c_azure2 = { 0xe0e0, 0xeeee, 0xeeee, 0xffff };
const rgba_t c_azure3 = { 0xc1c1, 0xcdcd, 0xcdcd, 0xffff };
const rgba_t c_azure4 = { 0x8383, 0x8b8b, 0x8b8b, 0xffff };
const rgba_t c_SlateBlue1 = { 0x8383, 0x6f6f, 0xffff, 0xffff };
const rgba_t c_SlateBlue2 = { 0x7a7a, 0x6767, 0xeeee, 0xffff };
const rgba_t c_SlateBlue3 = { 0x6969, 0x5959, 0xcdcd, 0xffff };
const rgba_t c_SlateBlue4 = { 0x4747, 0x3c3c, 0x8b8b, 0xffff };
const rgba_t c_RoyalBlue1 = { 0x4848, 0x7676, 0xffff, 0xffff };
const rgba_t c_RoyalBlue2 = { 0x4343, 0x6e6e, 0xeeee, 0xffff };
const rgba_t c_RoyalBlue3 = { 0x3a3a, 0x5f5f, 0xcdcd, 0xffff };
const rgba_t c_RoyalBlue4 = { 0x2727, 0x4040, 0x8b8b, 0xffff };
const rgba_t c_blue1 = { 0x0000, 0x0000, 0xffff, 0xffff };
const rgba_t c_blue2 = { 0x0000, 0x0000, 0xeeee, 0xffff };
const rgba_t c_blue3 = { 0x0000, 0x0000, 0xcdcd, 0xffff };
const rgba_t c_blue4 = { 0x0000, 0x0000, 0x8b8b, 0xffff };
const rgba_t c_DodgerBlue1 = { 0x1e1e, 0x9090, 0xffff, 0xffff };
const rgba_t c_DodgerBlue2 = { 0x1c1c, 0x8686, 0xeeee, 0xffff };
const rgba_t c_DodgerBlue3 = { 0x1818, 0x7474, 0xcdcd, 0xffff };
const rgba_t c_DodgerBlue4 = { 0x1010, 0x4e4e, 0x8b8b, 0xffff };
const rgba_t c_SteelBlue1 = { 0x6363, 0xb8b8, 0xffff, 0xffff };
const rgba_t c_SteelBlue2 = { 0x5c5c, 0xacac, 0xeeee, 0xffff };
const rgba_t c_SteelBlue3 = { 0x4f4f, 0x9494, 0xcdcd, 0xffff };
const rgba_t c_SteelBlue4 = { 0x3636, 0x6464, 0x8b8b, 0xffff };
const rgba_t c_DeepSkyBlue1 = { 0x0000, 0xbfbf, 0xffff, 0xffff };
const rgba_t c_DeepSkyBlue2 = { 0x0000, 0xb2b2, 0xeeee, 0xffff };
const rgba_t c_DeepSkyBlue3 = { 0x0000, 0x9a9a, 0xcdcd, 0xffff };
const rgba_t c_DeepSkyBlue4 = { 0x0000, 0x6868, 0x8b8b, 0xffff };
const rgba_t c_SkyBlue1 = { 0x8787, 0xcece, 0xffff, 0xffff };
const rgba_t c_SkyBlue2 = { 0x7e7e, 0xc0c0, 0xeeee, 0xffff };
const rgba_t c_SkyBlue3 = { 0x6c6c, 0xa6a6, 0xcdcd, 0xffff };
const rgba_t c_SkyBlue4 = { 0x4a4a, 0x7070, 0x8b8b, 0xffff };
const rgba_t c_LightSkyBlue1 = { 0xb0b0, 0xe2e2, 0xffff, 0xffff };
const rgba_t c_LightSkyBlue2 = { 0xa4a4, 0xd3d3, 0xeeee, 0xffff };
const rgba_t c_LightSkyBlue3 = { 0x8d8d, 0xb6b6, 0xcdcd, 0xffff };
const rgba_t c_LightSkyBlue4 = { 0x6060, 0x7b7b, 0x8b8b, 0xffff };
const rgba_t c_SlateGray1 = { 0xc6c6, 0xe2e2, 0xffff, 0xffff };
const rgba_t c_SlateGray2 = { 0xb9b9, 0xd3d3, 0xeeee, 0xffff };
const rgba_t c_SlateGray3 = { 0x9f9f, 0xb6b6, 0xcdcd, 0xffff };
const rgba_t c_SlateGray4 = { 0x6c6c, 0x7b7b, 0x8b8b, 0xffff };
const rgba_t c_LightSteelBlue1 = { 0xcaca, 0xe1e1, 0xffff, 0xffff };
const rgba_t c_LightSteelBlue2 = { 0xbcbc, 0xd2d2, 0xeeee, 0xffff };
const rgba_t c_LightSteelBlue3 = { 0xa2a2, 0xb5b5, 0xcdcd, 0xffff };
const rgba_t c_LightSteelBlue4 = { 0x6e6e, 0x7b7b, 0x8b8b, 0xffff };
const rgba_t c_LightBlue1 = { 0xbfbf, 0xefef, 0xffff, 0xffff };
const rgba_t c_LightBlue2 = { 0xb2b2, 0xdfdf, 0xeeee, 0xffff };
const rgba_t c_LightBlue3 = { 0x9a9a, 0xc0c0, 0xcdcd, 0xffff };
const rgba_t c_LightBlue4 = { 0x6868, 0x8383, 0x8b8b, 0xffff };
const rgba_t c_LightCyan1 = { 0xe0e0, 0xffff, 0xffff, 0xffff };
const rgba_t c_LightCyan2 = { 0xd1d1, 0xeeee, 0xeeee, 0xffff };
const rgba_t c_LightCyan3 = { 0xb4b4, 0xcdcd, 0xcdcd, 0xffff };
const rgba_t c_LightCyan4 = { 0x7a7a, 0x8b8b, 0x8b8b, 0xffff };
const rgba_t c_PaleTurquoise1 = { 0xbbbb, 0xffff, 0xffff, 0xffff };
const rgba_t c_PaleTurquoise2 = { 0xaeae, 0xeeee, 0xeeee, 0xffff };
const rgba_t c_PaleTurquoise3 = { 0x9696, 0xcdcd, 0xcdcd, 0xffff };
const rgba_t c_PaleTurquoise4 = { 0x6666, 0x8b8b, 0x8b8b, 0xffff };
const rgba_t c_CadetBlue1 = { 0x9898, 0xf5f5, 0xffff, 0xffff };
const rgba_t c_CadetBlue2 = { 0x8e8e, 0xe5e5, 0xeeee, 0xffff };
const rgba_t c_CadetBlue3 = { 0x7a7a, 0xc5c5, 0xcdcd, 0xffff };
const rgba_t c_CadetBlue4 = { 0x5353, 0x8686, 0x8b8b, 0xffff };
const rgba_t c_turquoise1 = { 0x0000, 0xf5f5, 0xffff, 0xffff };
const rgba_t c_turquoise2 = { 0x0000, 0xe5e5, 0xeeee, 0xffff };
const rgba_t c_turquoise3 = { 0x0000, 0xc5c5, 0xcdcd, 0xffff };
const rgba_t c_turquoise4 = { 0x0000, 0x8686, 0x8b8b, 0xffff };
const rgba_t c_cyan1 = { 0x0000, 0xffff, 0xffff, 0xffff };
const rgba_t c_cyan2 = { 0x0000, 0xeeee, 0xeeee, 0xffff };
const rgba_t c_cyan3 = { 0x0000, 0xcdcd, 0xcdcd, 0xffff };
const rgba_t c_cyan4 = { 0x0000, 0x8b8b, 0x8b8b, 0xffff };
const rgba_t c_DarkSlateGray1 = { 0x9797, 0xffff, 0xffff, 0xffff };
const rgba_t c_DarkSlateGray2 = { 0x8d8d, 0xeeee, 0xeeee, 0xffff };
const rgba_t c_DarkSlateGray3 = { 0x7979, 0xcdcd, 0xcdcd, 0xffff };
const rgba_t c_DarkSlateGray4 = { 0x5252, 0x8b8b, 0x8b8b, 0xffff };
const rgba_t c_aquamarine1 = { 0x7f7f, 0xffff, 0xd4d4, 0xffff };
const rgba_t c_aquamarine2 = { 0x7676, 0xeeee, 0xc6c6, 0xffff };
const rgba_t c_aquamarine3 = { 0x6666, 0xcdcd, 0xaaaa, 0xffff };
const rgba_t c_aquamarine4 = { 0x4545, 0x8b8b, 0x7474, 0xffff };
const rgba_t c_DarkSeaGreen1 = { 0xc1c1, 0xffff, 0xc1c1, 0xffff };
const rgba_t c_DarkSeaGreen2 = { 0xb4b4, 0xeeee, 0xb4b4, 0xffff };
const rgba_t c_DarkSeaGreen3 = { 0x9b9b, 0xcdcd, 0x9b9b, 0xffff };
const rgba_t c_DarkSeaGreen4 = { 0x6969, 0x8b8b, 0x6969, 0xffff };
const rgba_t c_SeaGreen1 = { 0x5454, 0xffff, 0x9f9f, 0xffff };
const rgba_t c_SeaGreen2 = { 0x4e4e, 0xeeee, 0x9494, 0xffff };
const rgba_t c_SeaGreen3 = { 0x4343, 0xcdcd, 0x8080, 0xffff };
const rgba_t c_SeaGreen4 = { 0x2e2e, 0x8b8b, 0x5757, 0xffff };
const rgba_t c_PaleGreen1 = { 0x9a9a, 0xffff, 0x9a9a, 0xffff };
const rgba_t c_PaleGreen2 = { 0x9090, 0xeeee, 0x9090, 0xffff };
const rgba_t c_PaleGreen3 = { 0x7c7c, 0xcdcd, 0x7c7c, 0xffff };
const rgba_t c_PaleGreen4 = { 0x5454, 0x8b8b, 0x5454, 0xffff };
const rgba_t c_SpringGreen1 = { 0x0000, 0xffff, 0x7f7f, 0xffff };
const rgba_t c_SpringGreen2 = { 0x0000, 0xeeee, 0x7676, 0xffff };
const rgba_t c_SpringGreen3 = { 0x0000, 0xcdcd, 0x6666, 0xffff };
const rgba_t c_SpringGreen4 = { 0x0000, 0x8b8b, 0x4545, 0xffff };
const rgba_t c_green1 = { 0x0000, 0xffff, 0x0000, 0xffff };
const rgba_t c_green2 = { 0x0000, 0xeeee, 0x0000, 0xffff };
const rgba_t c_green3 = { 0x0000, 0xcdcd, 0x0000, 0xffff };
const rgba_t c_green4 = { 0x0000, 0x8b8b, 0x0000, 0xffff };
const rgba_t c_chartreuse1 = { 0x7f7f, 0xffff, 0x0000, 0xffff };
const rgba_t c_chartreuse2 = { 0x7676, 0xeeee, 0x0000, 0xffff };
const rgba_t c_chartreuse3 = { 0x6666, 0xcdcd, 0x0000, 0xffff };
const rgba_t c_chartreuse4 = { 0x4545, 0x8b8b, 0x0000, 0xffff };
const rgba_t c_OliveDrab1 = { 0xc0c0, 0xffff, 0x3e3e, 0xffff };
const rgba_t c_OliveDrab2 = { 0xb3b3, 0xeeee, 0x3a3a, 0xffff };
const rgba_t c_OliveDrab3 = { 0x9a9a, 0xcdcd, 0x3232, 0xffff };
const rgba_t c_OliveDrab4 = { 0x6969, 0x8b8b, 0x2222, 0xffff };
const rgba_t c_DarkOliveGreen1 = { 0xcaca, 0xffff, 0x7070, 0xffff };
const rgba_t c_DarkOliveGreen2 = { 0xbcbc, 0xeeee, 0x6868, 0xffff };
const rgba_t c_DarkOliveGreen3 = { 0xa2a2, 0xcdcd, 0x5a5a, 0xffff };
const rgba_t c_DarkOliveGreen4 = { 0x6e6e, 0x8b8b, 0x3d3d, 0xffff };
const rgba_t c_khaki1 = { 0xffff, 0xf6f6, 0x8f8f, 0xffff };
const rgba_t c_khaki2 = { 0xeeee, 0xe6e6, 0x8585, 0xffff };
const rgba_t c_khaki3 = { 0xcdcd, 0xc6c6, 0x7373, 0xffff };
const rgba_t c_khaki4 = { 0x8b8b, 0x8686, 0x4e4e, 0xffff };
const rgba_t c_LightGoldenrod1 = { 0xffff, 0xecec, 0x8b8b, 0xffff };
const rgba_t c_LightGoldenrod2 = { 0xeeee, 0xdcdc, 0x8282, 0xffff };
const rgba_t c_LightGoldenrod3 = { 0xcdcd, 0xbebe, 0x7070, 0xffff };
const rgba_t c_LightGoldenrod4 = { 0x8b8b, 0x8181, 0x4c4c, 0xffff };
const rgba_t c_LightYellow1 = { 0xffff, 0xffff, 0xe0e0, 0xffff };
const rgba_t c_LightYellow2 = { 0xeeee, 0xeeee, 0xd1d1, 0xffff };
const rgba_t c_LightYellow3 = { 0xcdcd, 0xcdcd, 0xb4b4, 0xffff };
const rgba_t c_LightYellow4 = { 0x8b8b, 0x8b8b, 0x7a7a, 0xffff };
const rgba_t c_yellow1 = { 0xffff, 0xffff, 0x0000, 0xffff };
const rgba_t c_yellow2 = { 0xeeee, 0xeeee, 0x0000, 0xffff };
const rgba_t c_yellow3 = { 0xcdcd, 0xcdcd, 0x0000, 0xffff };
const rgba_t c_yellow4 = { 0x8b8b, 0x8b8b, 0x0000, 0xffff };
const rgba_t c_gold1 = { 0xffff, 0xd7d7, 0x0000, 0xffff };
const rgba_t c_gold2 = { 0xeeee, 0xc9c9, 0x0000, 0xffff };
const rgba_t c_gold3 = { 0xcdcd, 0xadad, 0x0000, 0xffff };
const rgba_t c_gold4 = { 0x8b8b, 0x7575, 0x0000, 0xffff };
const rgba_t c_goldenrod1 = { 0xffff, 0xc1c1, 0x2525, 0xffff };
const rgba_t c_goldenrod2 = { 0xeeee, 0xb4b4, 0x2222, 0xffff };
const rgba_t c_goldenrod3 = { 0xcdcd, 0x9b9b, 0x1d1d, 0xffff };
const rgba_t c_goldenrod4 = { 0x8b8b, 0x6969, 0x1414, 0xffff };
const rgba_t c_DarkGoldenrod1 = { 0xffff, 0xb9b9, 0x0f0f, 0xffff };
const rgba_t c_DarkGoldenrod2 = { 0xeeee, 0xadad, 0x0e0e, 0xffff };
const rgba_t c_DarkGoldenrod3 = { 0xcdcd, 0x9595, 0x0c0c, 0xffff };
const rgba_t c_DarkGoldenrod4 = { 0x8b8b, 0x6565, 0x0808, 0xffff };
const rgba_t c_RosyBrown1 = { 0xffff, 0xc1c1, 0xc1c1, 0xffff };
const rgba_t c_RosyBrown2 = { 0xeeee, 0xb4b4, 0xb4b4, 0xffff };
const rgba_t c_RosyBrown3 = { 0xcdcd, 0x9b9b, 0x9b9b, 0xffff };
const rgba_t c_RosyBrown4 = { 0x8b8b, 0x6969, 0x6969, 0xffff };
const rgba_t c_IndianRed1 = { 0xffff, 0x6a6a, 0x6a6a, 0xffff };
const rgba_t c_IndianRed2 = { 0xeeee, 0x6363, 0x6363, 0xffff };
const rgba_t c_IndianRed3 = { 0xcdcd, 0x5555, 0x5555, 0xffff };
const rgba_t c_IndianRed4 = { 0x8b8b, 0x3a3a, 0x3a3a, 0xffff };
const rgba_t c_sienna1 = { 0xffff, 0x8282, 0x4747, 0xffff };
const rgba_t c_sienna2 = { 0xeeee, 0x7979, 0x4242, 0xffff };
const rgba_t c_sienna3 = { 0xcdcd, 0x6868, 0x3939, 0xffff };
const rgba_t c_sienna4 = { 0x8b8b, 0x4747, 0x2626, 0xffff };
const rgba_t c_burlywood1 = { 0xffff, 0xd3d3, 0x9b9b, 0xffff };
const rgba_t c_burlywood2 = { 0xeeee, 0xc5c5, 0x9191, 0xffff };
const rgba_t c_burlywood3 = { 0xcdcd, 0xaaaa, 0x7d7d, 0xffff };
const rgba_t c_burlywood4 = { 0x8b8b, 0x7373, 0x5555, 0xffff };
const rgba_t c_wheat1 = { 0xffff, 0xe7e7, 0xbaba, 0xffff };
const rgba_t c_wheat2 = { 0xeeee, 0xd8d8, 0xaeae, 0xffff };
const rgba_t c_wheat3 = { 0xcdcd, 0xbaba, 0x9696, 0xffff };
const rgba_t c_wheat4 = { 0x8b8b, 0x7e7e, 0x6666, 0xffff };
const rgba_t c_tan1 = { 0xffff, 0xa5a5, 0x4f4f, 0xffff };
const rgba_t c_tan2 = { 0xeeee, 0x9a9a, 0x4949, 0xffff };
const rgba_t c_tan3 = { 0xcdcd, 0x8585, 0x3f3f, 0xffff };
const rgba_t c_tan4 = { 0x8b8b, 0x5a5a, 0x2b2b, 0xffff };
const rgba_t c_chocolate1 = { 0xffff, 0x7f7f, 0x2424, 0xffff };
const rgba_t c_chocolate2 = { 0xeeee, 0x7676, 0x2121, 0xffff };
const rgba_t c_chocolate3 = { 0xcdcd, 0x6666, 0x1d1d, 0xffff };
const rgba_t c_chocolate4 = { 0x8b8b, 0x4545, 0x1313, 0xffff };
const rgba_t c_firebrick1 = { 0xffff, 0x3030, 0x3030, 0xffff };
const rgba_t c_firebrick2 = { 0xeeee, 0x2c2c, 0x2c2c, 0xffff };
const rgba_t c_firebrick3 = { 0xcdcd, 0x2626, 0x2626, 0xffff };
const rgba_t c_firebrick4 = { 0x8b8b, 0x1a1a, 0x1a1a, 0xffff };
const rgba_t c_brown1 = { 0xffff, 0x4040, 0x4040, 0xffff };
const rgba_t c_brown2 = { 0xeeee, 0x3b3b, 0x3b3b, 0xffff };
const rgba_t c_brown3 = { 0xcdcd, 0x3333, 0x3333, 0xffff };
const rgba_t c_brown4 = { 0x8b8b, 0x2323, 0x2323, 0xffff };
const rgba_t c_salmon1 = { 0xffff, 0x8c8c, 0x6969, 0xffff };
const rgba_t c_salmon2 = { 0xeeee, 0x8282, 0x6262, 0xffff };
const rgba_t c_salmon3 = { 0xcdcd, 0x7070, 0x5454, 0xffff };
const rgba_t c_salmon4 = { 0x8b8b, 0x4c4c, 0x3939, 0xffff };
const rgba_t c_LightSalmon1 = { 0xffff, 0xa0a0, 0x7a7a, 0xffff };
const rgba_t c_LightSalmon2 = { 0xeeee, 0x9595, 0x7272, 0xffff };
const rgba_t c_LightSalmon3 = { 0xcdcd, 0x8181, 0x6262, 0xffff };
const rgba_t c_LightSalmon4 = { 0x8b8b, 0x5757, 0x4242, 0xffff };
const rgba_t c_orange1 = { 0xffff, 0xa5a5, 0x0000, 0xffff };
const rgba_t c_orange2 = { 0xeeee, 0x9a9a, 0x0000, 0xffff };
const rgba_t c_orange3 = { 0xcdcd, 0x8585, 0x0000, 0xffff };
const rgba_t c_orange4 = { 0x8b8b, 0x5a5a, 0x0000, 0xffff };
const rgba_t c_DarkOrange1 = { 0xffff, 0x7f7f, 0x0000, 0xffff };
const rgba_t c_DarkOrange2 = { 0xeeee, 0x7676, 0x0000, 0xffff };
const rgba_t c_DarkOrange3 = { 0xcdcd, 0x6666, 0x0000, 0xffff };
const rgba_t c_DarkOrange4 = { 0x8b8b, 0x4545, 0x0000, 0xffff };
const rgba_t c_coral1 = { 0xffff, 0x7272, 0x5656, 0xffff };
const rgba_t c_coral2 = { 0xeeee, 0x6a6a, 0x5050, 0xffff };
const rgba_t c_coral3 = { 0xcdcd, 0x5b5b, 0x4545, 0xffff };
const rgba_t c_coral4 = { 0x8b8b, 0x3e3e, 0x2f2f, 0xffff };
const rgba_t c_tomato1 = { 0xffff, 0x6363, 0x4747, 0xffff };
const rgba_t c_tomato2 = { 0xeeee, 0x5c5c, 0x4242, 0xffff };
const rgba_t c_tomato3 = { 0xcdcd, 0x4f4f, 0x3939, 0xffff };
const rgba_t c_tomato4 = { 0x8b8b, 0x3636, 0x2626, 0xffff };
const rgba_t c_OrangeRed1 = { 0xffff, 0x4545, 0x0000, 0xffff };
const rgba_t c_OrangeRed2 = { 0xeeee, 0x4040, 0x0000, 0xffff };
const rgba_t c_OrangeRed3 = { 0xcdcd, 0x3737, 0x0000, 0xffff };
const rgba_t c_OrangeRed4 = { 0x8b8b, 0x2525, 0x0000, 0xffff };
const rgba_t c_red1 = { 0xffff, 0x0000, 0x0000, 0xffff };
const rgba_t c_red2 = { 0xeeee, 0x0000, 0x0000, 0xffff };
const rgba_t c_red3 = { 0xcdcd, 0x0000, 0x0000, 0xffff };
const rgba_t c_red4 = { 0x8b8b, 0x0000, 0x0000, 0xffff };
const rgba_t c_DeepPink1 = { 0xffff, 0x1414, 0x9393, 0xffff };
const rgba_t c_DeepPink2 = { 0xeeee, 0x1212, 0x8989, 0xffff };
const rgba_t c_DeepPink3 = { 0xcdcd, 0x1010, 0x7676, 0xffff };
const rgba_t c_DeepPink4 = { 0x8b8b, 0x0a0a, 0x5050, 0xffff };
const rgba_t c_HotPink1 = { 0xffff, 0x6e6e, 0xb4b4, 0xffff };
const rgba_t c_HotPink2 = { 0xeeee, 0x6a6a, 0xa7a7, 0xffff };
const rgba_t c_HotPink3 = { 0xcdcd, 0x6060, 0x9090, 0xffff };
const rgba_t c_HotPink4 = { 0x8b8b, 0x3a3a, 0x6262, 0xffff };
const rgba_t c_pink1 = { 0xffff, 0xb5b5, 0xc5c5, 0xffff };
const rgba_t c_pink2 = { 0xeeee, 0xa9a9, 0xb8b8, 0xffff };
const rgba_t c_pink3 = { 0xcdcd, 0x9191, 0x9e9e, 0xffff };
const rgba_t c_pink4 = { 0x8b8b, 0x6363, 0x6c6c, 0xffff };
const rgba_t c_LightPink1 = { 0xffff, 0xaeae, 0xb9b9, 0xffff };
const rgba_t c_LightPink2 = { 0xeeee, 0xa2a2, 0xadad, 0xffff };
const rgba_t c_LightPink3 = { 0xcdcd, 0x8c8c, 0x9595, 0xffff };
const rgba_t c_LightPink4 = { 0x8b8b, 0x5f5f, 0x6565, 0xffff };
const rgba_t c_PaleVioletRed1 = { 0xffff, 0x8282, 0xabab, 0xffff };
const rgba_t c_PaleVioletRed2 = { 0xeeee, 0x7979, 0x9f9f, 0xffff };
const rgba_t c_PaleVioletRed3 = { 0xcdcd, 0x6868, 0x8989, 0xffff };
const rgba_t c_PaleVioletRed4 = { 0x8b8b, 0x4747, 0x5d5d, 0xffff };
const rgba_t c_maroon1 = { 0xffff, 0x3434, 0xb3b3, 0xffff };
const rgba_t c_maroon2 = { 0xeeee, 0x3030, 0xa7a7, 0xffff };
const rgba_t c_maroon3 = { 0xcdcd, 0x2929, 0x9090, 0xffff };
const rgba_t c_maroon4 = { 0x8b8b, 0x1c1c, 0x6262, 0xffff };
const rgba_t c_VioletRed1 = { 0xffff, 0x3e3e, 0x9696, 0xffff };
const rgba_t c_VioletRed2 = { 0xeeee, 0x3a3a, 0x8c8c, 0xffff };
const rgba_t c_VioletRed3 = { 0xcdcd, 0x3232, 0x7878, 0xffff };
const rgba_t c_VioletRed4 = { 0x8b8b, 0x2222, 0x5252, 0xffff };
const rgba_t c_magenta1 = { 0xffff, 0x0000, 0xffff, 0xffff };
const rgba_t c_magenta2 = { 0xeeee, 0x0000, 0xeeee, 0xffff };
const rgba_t c_magenta3 = { 0xcdcd, 0x0000, 0xcdcd, 0xffff };
const rgba_t c_magenta4 = { 0x8b8b, 0x0000, 0x8b8b, 0xffff };
const rgba_t c_orchid1 = { 0xffff, 0x8383, 0xfafa, 0xffff };
const rgba_t c_orchid2 = { 0xeeee, 0x7a7a, 0xe9e9, 0xffff };
const rgba_t c_orchid3 = { 0xcdcd, 0x6969, 0xc9c9, 0xffff };
const rgba_t c_orchid4 = { 0x8b8b, 0x4747, 0x8989, 0xffff };
const rgba_t c_plum1 = { 0xffff, 0xbbbb, 0xffff, 0xffff };
const rgba_t c_plum2 = { 0xeeee, 0xaeae, 0xeeee, 0xffff };
const rgba_t c_plum3 = { 0xcdcd, 0x9696, 0xcdcd, 0xffff };
const rgba_t c_plum4 = { 0x8b8b, 0x6666, 0x8b8b, 0xffff };
const rgba_t c_MediumOrchid1 = { 0xe0e0, 0x6666, 0xffff, 0xffff };
const rgba_t c_MediumOrchid2 = { 0xd1d1, 0x5f5f, 0xeeee, 0xffff };
const rgba_t c_MediumOrchid3 = { 0xb4b4, 0x5252, 0xcdcd, 0xffff };
const rgba_t c_MediumOrchid4 = { 0x7a7a, 0x3737, 0x8b8b, 0xffff };
const rgba_t c_DarkOrchid1 = { 0xbfbf, 0x3e3e, 0xffff, 0xffff };
const rgba_t c_DarkOrchid2 = { 0xb2b2, 0x3a3a, 0xeeee, 0xffff };
const rgba_t c_DarkOrchid3 = { 0x9a9a, 0x3232, 0xcdcd, 0xffff };
const rgba_t c_DarkOrchid4 = { 0x6868, 0x2222, 0x8b8b, 0xffff };
const rgba_t c_purple1 = { 0x9b9b, 0x3030, 0xffff, 0xffff };
const rgba_t c_purple2 = { 0x9191, 0x2c2c, 0xeeee, 0xffff };
const rgba_t c_purple3 = { 0x7d7d, 0x2626, 0xcdcd, 0xffff };
const rgba_t c_purple4 = { 0x5555, 0x1a1a, 0x8b8b, 0xffff };
const rgba_t c_MediumPurple1 = { 0xabab, 0x8282, 0xffff, 0xffff };
const rgba_t c_MediumPurple2 = { 0x9f9f, 0x7979, 0xeeee, 0xffff };
const rgba_t c_MediumPurple3 = { 0x8989, 0x6868, 0xcdcd, 0xffff };
const rgba_t c_MediumPurple4 = { 0x5d5d, 0x4747, 0x8b8b, 0xffff };
const rgba_t c_thistle1 = { 0xffff, 0xe1e1, 0xffff, 0xffff };
const rgba_t c_thistle2 = { 0xeeee, 0xd2d2, 0xeeee, 0xffff };
const rgba_t c_thistle3 = { 0xcdcd, 0xb5b5, 0xcdcd, 0xffff };
const rgba_t c_thistle4 = { 0x8b8b, 0x7b7b, 0x8b8b, 0xffff };
const rgba_t c_gray0 = { 0x0000, 0x0000, 0x0000, 0xffff };
const rgba_t c_grey0 = { 0x0000, 0x0000, 0x0000, 0xffff };
const rgba_t c_gray1 = { 0x0303, 0x0303, 0x0303, 0xffff };
const rgba_t c_grey1 = { 0x0303, 0x0303, 0x0303, 0xffff };
const rgba_t c_gray2 = { 0x0505, 0x0505, 0x0505, 0xffff };
const rgba_t c_grey2 = { 0x0505, 0x0505, 0x0505, 0xffff };
const rgba_t c_gray3 = { 0x0808, 0x0808, 0x0808, 0xffff };
const rgba_t c_grey3 = { 0x0808, 0x0808, 0x0808, 0xffff };
const rgba_t c_gray4 = { 0x0a0a, 0x0a0a, 0x0a0a, 0xffff };
const rgba_t c_grey4 = { 0x0a0a, 0x0a0a, 0x0a0a, 0xffff };
const rgba_t c_gray5 = { 0x0d0d, 0x0d0d, 0x0d0d, 0xffff };
const rgba_t c_grey5 = { 0x0d0d, 0x0d0d, 0x0d0d, 0xffff };
const rgba_t c_gray6 = { 0x0f0f, 0x0f0f, 0x0f0f, 0xffff };
const rgba_t c_grey6 = { 0x0f0f, 0x0f0f, 0x0f0f, 0xffff };
const rgba_t c_gray7 = { 0x1212, 0x1212, 0x1212, 0xffff };
const rgba_t c_grey7 = { 0x1212, 0x1212, 0x1212, 0xffff };
const rgba_t c_gray8 = { 0x1414, 0x1414, 0x1414, 0xffff };
const rgba_t c_grey8 = { 0x1414, 0x1414, 0x1414, 0xffff };
const rgba_t c_gray9 = { 0x1717, 0x1717, 0x1717, 0xffff };
const rgba_t c_grey9 = { 0x1717, 0x1717, 0x1717, 0xffff };
const rgba_t c_gray10 = { 0x1a1a, 0x1a1a, 0x1a1a, 0xffff };
const rgba_t c_grey10 = { 0x1a1a, 0x1a1a, 0x1a1a, 0xffff };
const rgba_t c_gray11 = { 0x1c1c, 0x1c1c, 0x1c1c, 0xffff };
const rgba_t c_grey11 = { 0x1c1c, 0x1c1c, 0x1c1c, 0xffff };
const rgba_t c_gray12 = { 0x1f1f, 0x1f1f, 0x1f1f, 0xffff };
const rgba_t c_grey12 = { 0x1f1f, 0x1f1f, 0x1f1f, 0xffff };
const rgba_t c_gray13 = { 0x2121, 0x2121, 0x2121, 0xffff };
const rgba_t c_grey13 = { 0x2121, 0x2121, 0x2121, 0xffff };
const rgba_t c_gray14 = { 0x2424, 0x2424, 0x2424, 0xffff };
const rgba_t c_grey14 = { 0x2424, 0x2424, 0x2424, 0xffff };
const rgba_t c_gray15 = { 0x2626, 0x2626, 0x2626, 0xffff };
const rgba_t c_grey15 = { 0x2626, 0x2626, 0x2626, 0xffff };
const rgba_t c_gray16 = { 0x2929, 0x2929, 0x2929, 0xffff };
const rgba_t c_grey16 = { 0x2929, 0x2929, 0x2929, 0xffff };
const rgba_t c_gray17 = { 0x2b2b, 0x2b2b, 0x2b2b, 0xffff };
const rgba_t c_grey17 = { 0x2b2b, 0x2b2b, 0x2b2b, 0xffff };
const rgba_t c_gray18 = { 0x2e2e, 0x2e2e, 0x2e2e, 0xffff };
const rgba_t c_grey18 = { 0x2e2e, 0x2e2e, 0x2e2e, 0xffff };
const rgba_t c_gray19 = { 0x3030, 0x3030, 0x3030, 0xffff };
const rgba_t c_grey19 = { 0x3030, 0x3030, 0x3030, 0xffff };
const rgba_t c_gray20 = { 0x3333, 0x3333, 0x3333, 0xffff };
const rgba_t c_grey20 = { 0x3333, 0x3333, 0x3333, 0xffff };
const rgba_t c_gray21 = { 0x3636, 0x3636, 0x3636, 0xffff };
const rgba_t c_grey21 = { 0x3636, 0x3636, 0x3636, 0xffff };
const rgba_t c_gray22 = { 0x3838, 0x3838, 0x3838, 0xffff };
const rgba_t c_grey22 = { 0x3838, 0x3838, 0x3838, 0xffff };
const rgba_t c_gray23 = { 0x3b3b, 0x3b3b, 0x3b3b, 0xffff };
const rgba_t c_grey23 = { 0x3b3b, 0x3b3b, 0x3b3b, 0xffff };
const rgba_t c_gray24 = { 0x3d3d, 0x3d3d, 0x3d3d, 0xffff };
const rgba_t c_grey24 = { 0x3d3d, 0x3d3d, 0x3d3d, 0xffff };
const rgba_t c_gray25 = { 0x4040, 0x4040, 0x4040, 0xffff };
const rgba_t c_grey25 = { 0x4040, 0x4040, 0x4040, 0xffff };
const rgba_t c_gray26 = { 0x4242, 0x4242, 0x4242, 0xffff };
const rgba_t c_grey26 = { 0x4242, 0x4242, 0x4242, 0xffff };
const rgba_t c_gray27 = { 0x4545, 0x4545, 0x4545, 0xffff };
const rgba_t c_grey27 = { 0x4545, 0x4545, 0x4545, 0xffff };
const rgba_t c_gray28 = { 0x4747, 0x4747, 0x4747, 0xffff };
const rgba_t c_grey28 = { 0x4747, 0x4747, 0x4747, 0xffff };
const rgba_t c_gray29 = { 0x4a4a, 0x4a4a, 0x4a4a, 0xffff };
const rgba_t c_grey29 = { 0x4a4a, 0x4a4a, 0x4a4a, 0xffff };
const rgba_t c_gray30 = { 0x4d4d, 0x4d4d, 0x4d4d, 0xffff };
const rgba_t c_grey30 = { 0x4d4d, 0x4d4d, 0x4d4d, 0xffff };
const rgba_t c_gray31 = { 0x4f4f, 0x4f4f, 0x4f4f, 0xffff };
const rgba_t c_grey31 = { 0x4f4f, 0x4f4f, 0x4f4f, 0xffff };
const rgba_t c_gray32 = { 0x5252, 0x5252, 0x5252, 0xffff };
const rgba_t c_grey32 = { 0x5252, 0x5252, 0x5252, 0xffff };
const rgba_t c_gray33 = { 0x5454, 0x5454, 0x5454, 0xffff };
const rgba_t c_grey33 = { 0x5454, 0x5454, 0x5454, 0xffff };
const rgba_t c_gray34 = { 0x5757, 0x5757, 0x5757, 0xffff };
const rgba_t c_grey34 = { 0x5757, 0x5757, 0x5757, 0xffff };
const rgba_t c_gray35 = { 0x5959, 0x5959, 0x5959, 0xffff };
const rgba_t c_grey35 = { 0x5959, 0x5959, 0x5959, 0xffff };
const rgba_t c_gray36 = { 0x5c5c, 0x5c5c, 0x5c5c, 0xffff };
const rgba_t c_grey36 = { 0x5c5c, 0x5c5c, 0x5c5c, 0xffff };
const rgba_t c_gray37 = { 0x5e5e, 0x5e5e, 0x5e5e, 0xffff };
const rgba_t c_grey37 = { 0x5e5e, 0x5e5e, 0x5e5e, 0xffff };
const rgba_t c_gray38 = { 0x6161, 0x6161, 0x6161, 0xffff };
const rgba_t c_grey38 = { 0x6161, 0x6161, 0x6161, 0xffff };
const rgba_t c_gray39 = { 0x6363, 0x6363, 0x6363, 0xffff };
const rgba_t c_grey39 = { 0x6363, 0x6363, 0x6363, 0xffff };
const rgba_t c_gray40 = { 0x6666, 0x6666, 0x6666, 0xffff };
const rgba_t c_grey40 = { 0x6666, 0x6666, 0x6666, 0xffff };
const rgba_t c_gray41 = { 0x6969, 0x6969, 0x6969, 0xffff };
const rgba_t c_grey41 = { 0x6969, 0x6969, 0x6969, 0xffff };
const rgba_t c_gray42 = { 0x6b6b, 0x6b6b, 0x6b6b, 0xffff };
const rgba_t c_grey42 = { 0x6b6b, 0x6b6b, 0x6b6b, 0xffff };
const rgba_t c_gray43 = { 0x6e6e, 0x6e6e, 0x6e6e, 0xffff };
const rgba_t c_grey43 = { 0x6e6e, 0x6e6e, 0x6e6e, 0xffff };
const rgba_t c_gray44 = { 0x7070, 0x7070, 0x7070, 0xffff };
const rgba_t c_grey44 = { 0x7070, 0x7070, 0x7070, 0xffff };
const rgba_t c_gray45 = { 0x7373, 0x7373, 0x7373, 0xffff };
const rgba_t c_grey45 = { 0x7373, 0x7373, 0x7373, 0xffff };
const rgba_t c_gray46 = { 0x7575, 0x7575, 0x7575, 0xffff };
const rgba_t c_grey46 = { 0x7575, 0x7575, 0x7575, 0xffff };
const rgba_t c_gray47 = { 0x7878, 0x7878, 0x7878, 0xffff };
const rgba_t c_grey47 = { 0x7878, 0x7878, 0x7878, 0xffff };
const rgba_t c_gray48 = { 0x7a7a, 0x7a7a, 0x7a7a, 0xffff };
const rgba_t c_grey48 = { 0x7a7a, 0x7a7a, 0x7a7a, 0xffff };
const rgba_t c_gray49 = { 0x7d7d, 0x7d7d, 0x7d7d, 0xffff };
const rgba_t c_grey49 = { 0x7d7d, 0x7d7d, 0x7d7d, 0xffff };
const rgba_t c_gray50 = { 0x7f7f, 0x7f7f, 0x7f7f, 0xffff };
const rgba_t c_grey50 = { 0x7f7f, 0x7f7f, 0x7f7f, 0xffff };
const rgba_t c_gray51 = { 0x8282, 0x8282, 0x8282, 0xffff };
const rgba_t c_grey51 = { 0x8282, 0x8282, 0x8282, 0xffff };
const rgba_t c_gray52 = { 0x8585, 0x8585, 0x8585, 0xffff };
const rgba_t c_grey52 = { 0x8585, 0x8585, 0x8585, 0xffff };
const rgba_t c_gray53 = { 0x8787, 0x8787, 0x8787, 0xffff };
const rgba_t c_grey53 = { 0x8787, 0x8787, 0x8787, 0xffff };
const rgba_t c_gray54 = { 0x8a8a, 0x8a8a, 0x8a8a, 0xffff };
const rgba_t c_grey54 = { 0x8a8a, 0x8a8a, 0x8a8a, 0xffff };
const rgba_t c_gray55 = { 0x8c8c, 0x8c8c, 0x8c8c, 0xffff };
const rgba_t c_grey55 = { 0x8c8c, 0x8c8c, 0x8c8c, 0xffff };
const rgba_t c_gray56 = { 0x8f8f, 0x8f8f, 0x8f8f, 0xffff };
const rgba_t c_grey56 = { 0x8f8f, 0x8f8f, 0x8f8f, 0xffff };
const rgba_t c_gray57 = { 0x9191, 0x9191, 0x9191, 0xffff };
const rgba_t c_grey57 = { 0x9191, 0x9191, 0x9191, 0xffff };
const rgba_t c_gray58 = { 0x9494, 0x9494, 0x9494, 0xffff };
const rgba_t c_grey58 = { 0x9494, 0x9494, 0x9494, 0xffff };
const rgba_t c_gray59 = { 0x9696, 0x9696, 0x9696, 0xffff };
const rgba_t c_grey59 = { 0x9696, 0x9696, 0x9696, 0xffff };
const rgba_t c_gray60 = { 0x9999, 0x9999, 0x9999, 0xffff };
const rgba_t c_grey60 = { 0x9999, 0x9999, 0x9999, 0xffff };
const rgba_t c_gray61 = { 0x9c9c, 0x9c9c, 0x9c9c, 0xffff };
const rgba_t c_grey61 = { 0x9c9c, 0x9c9c, 0x9c9c, 0xffff };
const rgba_t c_gray62 = { 0x9e9e, 0x9e9e, 0x9e9e, 0xffff };
const rgba_t c_grey62 = { 0x9e9e, 0x9e9e, 0x9e9e, 0xffff };
const rgba_t c_gray63 = { 0xa1a1, 0xa1a1, 0xa1a1, 0xffff };
const rgba_t c_grey63 = { 0xa1a1, 0xa1a1, 0xa1a1, 0xffff };
const rgba_t c_gray64 = { 0xa3a3, 0xa3a3, 0xa3a3, 0xffff };
const rgba_t c_grey64 = { 0xa3a3, 0xa3a3, 0xa3a3, 0xffff };
const rgba_t c_gray65 = { 0xa6a6, 0xa6a6, 0xa6a6, 0xffff };
const rgba_t c_grey65 = { 0xa6a6, 0xa6a6, 0xa6a6, 0xffff };
const rgba_t c_gray66 = { 0xa8a8, 0xa8a8, 0xa8a8, 0xffff };
const rgba_t c_grey66 = { 0xa8a8, 0xa8a8, 0xa8a8, 0xffff };
const rgba_t c_gray67 = { 0xabab, 0xabab, 0xabab, 0xffff };
const rgba_t c_grey67 = { 0xabab, 0xabab, 0xabab, 0xffff };
const rgba_t c_gray68 = { 0xadad, 0xadad, 0xadad, 0xffff };
const rgba_t c_grey68 = { 0xadad, 0xadad, 0xadad, 0xffff };
const rgba_t c_gray69 = { 0xb0b0, 0xb0b0, 0xb0b0, 0xffff };
const rgba_t c_grey69 = { 0xb0b0, 0xb0b0, 0xb0b0, 0xffff };
const rgba_t c_gray70 = { 0xb3b3, 0xb3b3, 0xb3b3, 0xffff };
const rgba_t c_grey70 = { 0xb3b3, 0xb3b3, 0xb3b3, 0xffff };
const rgba_t c_gray71 = { 0xb5b5, 0xb5b5, 0xb5b5, 0xffff };
const rgba_t c_grey71 = { 0xb5b5, 0xb5b5, 0xb5b5, 0xffff };
const rgba_t c_gray72 = { 0xb8b8, 0xb8b8, 0xb8b8, 0xffff };
const rgba_t c_grey72 = { 0xb8b8, 0xb8b8, 0xb8b8, 0xffff };
const rgba_t c_gray73 = { 0xbaba, 0xbaba, 0xbaba, 0xffff };
const rgba_t c_grey73 = { 0xbaba, 0xbaba, 0xbaba, 0xffff };
const rgba_t c_gray74 = { 0xbdbd, 0xbdbd, 0xbdbd, 0xffff };
const rgba_t c_grey74 = { 0xbdbd, 0xbdbd, 0xbdbd, 0xffff };
const rgba_t c_gray75 = { 0xbfbf, 0xbfbf, 0xbfbf, 0xffff };
const rgba_t c_grey75 = { 0xbfbf, 0xbfbf, 0xbfbf, 0xffff };
const rgba_t c_gray76 = { 0xc2c2, 0xc2c2, 0xc2c2, 0xffff };
const rgba_t c_grey76 = { 0xc2c2, 0xc2c2, 0xc2c2, 0xffff };
const rgba_t c_gray77 = { 0xc4c4, 0xc4c4, 0xc4c4, 0xffff };
const rgba_t c_grey77 = { 0xc4c4, 0xc4c4, 0xc4c4, 0xffff };
const rgba_t c_gray78 = { 0xc7c7, 0xc7c7, 0xc7c7, 0xffff };
const rgba_t c_grey78 = { 0xc7c7, 0xc7c7, 0xc7c7, 0xffff };
const rgba_t c_gray79 = { 0xc9c9, 0xc9c9, 0xc9c9, 0xffff };
const rgba_t c_grey79 = { 0xc9c9, 0xc9c9, 0xc9c9, 0xffff };
const rgba_t c_gray80 = { 0xcccc, 0xcccc, 0xcccc, 0xffff };
const rgba_t c_grey80 = { 0xcccc, 0xcccc, 0xcccc, 0xffff };
const rgba_t c_gray81 = { 0xcfcf, 0xcfcf, 0xcfcf, 0xffff };
const rgba_t c_grey81 = { 0xcfcf, 0xcfcf, 0xcfcf, 0xffff };
const rgba_t c_gray82 = { 0xd1d1, 0xd1d1, 0xd1d1, 0xffff };
const rgba_t c_grey82 = { 0xd1d1, 0xd1d1, 0xd1d1, 0xffff };
const rgba_t c_gray83 = { 0xd4d4, 0xd4d4, 0xd4d4, 0xffff };
const rgba_t c_grey83 = { 0xd4d4, 0xd4d4, 0xd4d4, 0xffff };
const rgba_t c_gray84 = { 0xd6d6, 0xd6d6, 0xd6d6, 0xffff };
const rgba_t c_grey84 = { 0xd6d6, 0xd6d6, 0xd6d6, 0xffff };
const rgba_t c_gray85 = { 0xd9d9, 0xd9d9, 0xd9d9, 0xffff };
const rgba_t c_grey85 = { 0xd9d9, 0xd9d9, 0xd9d9, 0xffff };
const rgba_t c_gray86 = { 0xdbdb, 0xdbdb, 0xdbdb, 0xffff };
const rgba_t c_grey86 = { 0xdbdb, 0xdbdb, 0xdbdb, 0xffff };
const rgba_t c_gray87 = { 0xdede, 0xdede, 0xdede, 0xffff };
const rgba_t c_grey87 = { 0xdede, 0xdede, 0xdede, 0xffff };
const rgba_t c_gray88 = { 0xe0e0, 0xe0e0, 0xe0e0, 0xffff };
const rgba_t c_grey88 = { 0xe0e0, 0xe0e0, 0xe0e0, 0xffff };
const rgba_t c_gray89 = { 0xe3e3, 0xe3e3, 0xe3e3, 0xffff };
const rgba_t c_grey89 = { 0xe3e3, 0xe3e3, 0xe3e3, 0xffff };
const rgba_t c_gray90 = { 0xe5e5, 0xe5e5, 0xe5e5, 0xffff };
const rgba_t c_grey90 = { 0xe5e5, 0xe5e5, 0xe5e5, 0xffff };
const rgba_t c_gray91 = { 0xe8e8, 0xe8e8, 0xe8e8, 0xffff };
const rgba_t c_grey91 = { 0xe8e8, 0xe8e8, 0xe8e8, 0xffff };
const rgba_t c_gray92 = { 0xebeb, 0xebeb, 0xebeb, 0xffff };
const rgba_t c_grey92 = { 0xebeb, 0xebeb, 0xebeb, 0xffff };
const rgba_t c_gray93 = { 0xeded, 0xeded, 0xeded, 0xffff };
const rgba_t c_grey93 = { 0xeded, 0xeded, 0xeded, 0xffff };
const rgba_t c_gray94 = { 0xf0f0, 0xf0f0, 0xf0f0, 0xffff };
const rgba_t c_grey94 = { 0xf0f0, 0xf0f0, 0xf0f0, 0xffff };
const rgba_t c_gray95 = { 0xf2f2, 0xf2f2, 0xf2f2, 0xffff };
const rgba_t c_grey95 = { 0xf2f2, 0xf2f2, 0xf2f2, 0xffff };
const rgba_t c_gray96 = { 0xf5f5, 0xf5f5, 0xf5f5, 0xffff };
const rgba_t c_grey96 = { 0xf5f5, 0xf5f5, 0xf5f5, 0xffff };
const rgba_t c_gray97 = { 0xf7f7, 0xf7f7, 0xf7f7, 0xffff };
const rgba_t c_grey97 = { 0xf7f7, 0xf7f7, 0xf7f7, 0xffff };
const rgba_t c_gray98 = { 0xfafa, 0xfafa, 0xfafa, 0xffff };
const rgba_t c_grey98 = { 0xfafa, 0xfafa, 0xfafa, 0xffff };
const rgba_t c_gray99 = { 0xfcfc, 0xfcfc, 0xfcfc, 0xffff };
const rgba_t c_grey99 = { 0xfcfc, 0xfcfc, 0xfcfc, 0xffff };
const rgba_t c_gray100 = { 0xffff, 0xffff, 0xffff, 0xffff };
const rgba_t c_grey100 = { 0xffff, 0xffff, 0xffff, 0xffff };
const rgba_t c_dark_grey = { 0xa9a9, 0xa9a9, 0xa9a9, 0xffff };
const rgba_t c_DarkGrey = { 0xa9a9, 0xa9a9, 0xa9a9, 0xffff };
const rgba_t c_dark_gray = { 0xa9a9, 0xa9a9, 0xa9a9, 0xffff };
const rgba_t c_DarkGray = { 0xa9a9, 0xa9a9, 0xa9a9, 0xffff };
const rgba_t c_dark_blue = { 0x0000, 0x0000, 0x8b8b, 0xffff };
const rgba_t c_DarkBlue = { 0x0000, 0x0000, 0x8b8b, 0xffff };
const rgba_t c_dark_cyan = { 0x0000, 0x8b8b, 0x8b8b, 0xffff };
const rgba_t c_DarkCyan = { 0x0000, 0x8b8b, 0x8b8b, 0xffff };
const rgba_t c_dark_magenta = { 0x8b8b, 0x0000, 0x8b8b, 0xffff };
const rgba_t c_DarkMagenta = { 0x8b8b, 0x0000, 0x8b8b, 0xffff };
const rgba_t c_dark_red = { 0x8b8b, 0x0000, 0x0000, 0xffff };
const rgba_t c_DarkRed = { 0x8b8b, 0x0000, 0x0000, 0xffff };
const rgba_t c_light_green = { 0x9090, 0xeeee, 0x9090, 0xffff };
const rgba_t c_LightGreen = { 0x9090, 0xeeee, 0x9090, 0xffff };


    /*
     *  Calculate a weighted difference between two colors
     */

u32 color_error(const rgba_t *a, const rgba_t *b)
{
    u32 error = abs(a->r-b->r)+abs(a->g-b->g)+abs(a->b-b->b);
    return RGB_WEIGHT*error+abs(a->a-b->a);
}


    /*
     *  Add two colors: a = b+c
     */

void color_add(rgba_t *a, const rgba_t *b, const rgba_t *c)
{
    a->r = b->r+c->r;
    a->g = b->g+c->g;
    a->b = b->b+c->b;
    a->a = b->a+c->a;
}


    /*
     *  Subtract two colors: a = b-c
     */

void color_sub(rgba_t *a, const rgba_t *b, const rgba_t *c)
{
    a->r = b->r-c->r;
    a->g = b->g-c->g;
    a->b = b->b-c->b;
    a->a = b->a-c->a;
}


    /*
     *  Find the index of the closest color in a CLUT
     */

u32 color_find(const rgba_t *color, const rgba_t *clut, u32 clut_size)
{
    u32 idx, best_idx, error, best_error;

    best_idx = 0;
    best_error = color_error(&clut[0], color);
    for (idx = 1; idx < clut_size; idx++) {
	error = color_error(&clut[idx], color);
	if (error < best_error) {
	    best_idx = idx;
	    best_error = error;
	}
    }
    return best_idx;
}


    /*
     *  RGB/YUV conversions
     */

/* Fast saturation from Imlib2 */
#define SATURATE_BOTH(out, in)				\
    do {						\
	unsigned int tmp = (in);			\
	out = (tmp | (-(tmp >> 8))) & (~(tmp >> 9));	\
    } while (0)

void yuva_to_rgba(const yuva_t *yuva, rgba_t *rgba)
{
    u8 y, u, v, r, g, b;

    /* The actual conversion is done in 8 bit */
    y = yuva->y >> 8;
    u = yuva->u >> 8;
    v = yuva->v >> 8;

    /* YUV to RGB */
    SATURATE_BOTH(r, (298*(y-16)+409*(v-128))/256);
    SATURATE_BOTH(g, (298*(y-16)-100*(u-128)-208*(v-128))/256);
    SATURATE_BOTH(b, (298*(y-16)+516*(u-128))/256);

    /* Expand to 16 bit */
    rgba->r = (r << 8) | r;
    rgba->g = (g << 8) | g;
    rgba->b = (b << 8) | b;

    rgba->a = yuva->a;
}

void rgba_to_yuva(const rgba_t *rgba, yuva_t *yuva)
{
    int r, g, b, y, u, v;

    /* The actual conversion is done in 8 bit */
    r = rgba->r >> 8;
    g = rgba->g >> 8;
    b = rgba->b >> 8;

    /* RGB to YUV */
    SATURATE_BOTH(y, ((66*r+129*g+25*b)/256)+16);
    SATURATE_BOTH(u, (128*256-38*r-74*g+112*b)/256);
    SATURATE_BOTH(v, (128*256+112*r-94*g-18*b)/256);

    /* Expand to 16 bit */
    yuva->y = (y << 8) | y;
    yuva->u = (u << 8) | u;
    yuva->v = (v << 8) | v;

    yuva->a = rgba->a;
}

