
/*
 *  Color manipulation
 *
 *  (C) Copyright 2001 Geert Uytterhoeven
 *
 *  This file is subject to the terms and conditions of the GNU General Public
 *  License. See the file COPYING in the main directory of this archive for
 *  more details.
 */


extern u32 color_error(const rgba_t *a, const rgba_t *b);
extern void color_add(rgba_t *a, const rgba_t *b, const rgba_t *c);
extern void color_sub(rgba_t *a, const rgba_t *b, const rgba_t *c);
extern u32 color_find(const rgba_t *color, const rgba_t *clut, u32 clutsize);


    /*
     *  RGB/YUV conversions
     */

extern void yuva_to_rgba(const yuva_t *yuva, rgba_t *rgba);
extern void rgba_to_yuva(const rgba_t *rgba, yuva_t *yuva);


    /*
     *  X11 colors from rgb.txt
     */

extern const rgba_t c_snow;
extern const rgba_t c_ghost_white;
extern const rgba_t c_GhostWhite;
extern const rgba_t c_white_smoke;
extern const rgba_t c_WhiteSmoke;
extern const rgba_t c_gainsboro;
extern const rgba_t c_floral_white;
extern const rgba_t c_FloralWhite;
extern const rgba_t c_old_lace;
extern const rgba_t c_OldLace;
extern const rgba_t c_linen;
extern const rgba_t c_antique_white;
extern const rgba_t c_AntiqueWhite;
extern const rgba_t c_papaya_whip;
extern const rgba_t c_PapayaWhip;
extern const rgba_t c_blanched_almond;
extern const rgba_t c_BlanchedAlmond;
extern const rgba_t c_bisque;
extern const rgba_t c_peach_puff;
extern const rgba_t c_PeachPuff;
extern const rgba_t c_navajo_white;
extern const rgba_t c_NavajoWhite;
extern const rgba_t c_moccasin;
extern const rgba_t c_cornsilk;
extern const rgba_t c_ivory;
extern const rgba_t c_lemon_chiffon;
extern const rgba_t c_LemonChiffon;
extern const rgba_t c_seashell;
extern const rgba_t c_honeydew;
extern const rgba_t c_mint_cream;
extern const rgba_t c_MintCream;
extern const rgba_t c_azure;
extern const rgba_t c_alice_blue;
extern const rgba_t c_AliceBlue;
extern const rgba_t c_lavender;
extern const rgba_t c_lavender_blush;
extern const rgba_t c_LavenderBlush;
extern const rgba_t c_misty_rose;
extern const rgba_t c_MistyRose;
extern const rgba_t c_white;
extern const rgba_t c_black;
extern const rgba_t c_dark_slate_gray;
extern const rgba_t c_DarkSlateGray;
extern const rgba_t c_dark_slate_grey;
extern const rgba_t c_DarkSlateGrey;
extern const rgba_t c_dim_gray;
extern const rgba_t c_DimGray;
extern const rgba_t c_dim_grey;
extern const rgba_t c_DimGrey;
extern const rgba_t c_slate_gray;
extern const rgba_t c_SlateGray;
extern const rgba_t c_slate_grey;
extern const rgba_t c_SlateGrey;
extern const rgba_t c_light_slate_gray;
extern const rgba_t c_LightSlateGray;
extern const rgba_t c_light_slate_grey;
extern const rgba_t c_LightSlateGrey;
extern const rgba_t c_gray;
extern const rgba_t c_grey;
extern const rgba_t c_light_grey;
extern const rgba_t c_LightGrey;
extern const rgba_t c_light_gray;
extern const rgba_t c_LightGray;
extern const rgba_t c_midnight_blue;
extern const rgba_t c_MidnightBlue;
extern const rgba_t c_navy;
extern const rgba_t c_navy_blue;
extern const rgba_t c_NavyBlue;
extern const rgba_t c_cornflower_blue;
extern const rgba_t c_CornflowerBlue;
extern const rgba_t c_dark_slate_blue;
extern const rgba_t c_DarkSlateBlue;
extern const rgba_t c_slate_blue;
extern const rgba_t c_SlateBlue;
extern const rgba_t c_medium_slate_blue;
extern const rgba_t c_MediumSlateBlue;
extern const rgba_t c_light_slate_blue;
extern const rgba_t c_LightSlateBlue;
extern const rgba_t c_medium_blue;
extern const rgba_t c_MediumBlue;
extern const rgba_t c_royal_blue;
extern const rgba_t c_RoyalBlue;
extern const rgba_t c_blue;
extern const rgba_t c_dodger_blue;
extern const rgba_t c_DodgerBlue;
extern const rgba_t c_deep_sky_blue;
extern const rgba_t c_DeepSkyBlue;
extern const rgba_t c_sky_blue;
extern const rgba_t c_SkyBlue;
extern const rgba_t c_light_sky_blue;
extern const rgba_t c_LightSkyBlue;
extern const rgba_t c_steel_blue;
extern const rgba_t c_SteelBlue;
extern const rgba_t c_light_steel_blue;
extern const rgba_t c_LightSteelBlue;
extern const rgba_t c_light_blue;
extern const rgba_t c_LightBlue;
extern const rgba_t c_powder_blue;
extern const rgba_t c_PowderBlue;
extern const rgba_t c_pale_turquoise;
extern const rgba_t c_PaleTurquoise;
extern const rgba_t c_dark_turquoise;
extern const rgba_t c_DarkTurquoise;
extern const rgba_t c_medium_turquoise;
extern const rgba_t c_MediumTurquoise;
extern const rgba_t c_turquoise;
extern const rgba_t c_cyan;
extern const rgba_t c_light_cyan;
extern const rgba_t c_LightCyan;
extern const rgba_t c_cadet_blue;
extern const rgba_t c_CadetBlue;
extern const rgba_t c_medium_aquamarine;
extern const rgba_t c_MediumAquamarine;
extern const rgba_t c_aquamarine;
extern const rgba_t c_dark_green;
extern const rgba_t c_DarkGreen;
extern const rgba_t c_dark_olive_green;
extern const rgba_t c_DarkOliveGreen;
extern const rgba_t c_dark_sea_green;
extern const rgba_t c_DarkSeaGreen;
extern const rgba_t c_sea_green;
extern const rgba_t c_SeaGreen;
extern const rgba_t c_medium_sea_green;
extern const rgba_t c_MediumSeaGreen;
extern const rgba_t c_light_sea_green;
extern const rgba_t c_LightSeaGreen;
extern const rgba_t c_pale_green;
extern const rgba_t c_PaleGreen;
extern const rgba_t c_spring_green;
extern const rgba_t c_SpringGreen;
extern const rgba_t c_lawn_green;
extern const rgba_t c_LawnGreen;
extern const rgba_t c_green;
extern const rgba_t c_chartreuse;
extern const rgba_t c_medium_spring_green;
extern const rgba_t c_MediumSpringGreen;
extern const rgba_t c_green_yellow;
extern const rgba_t c_GreenYellow;
extern const rgba_t c_lime_green;
extern const rgba_t c_LimeGreen;
extern const rgba_t c_yellow_green;
extern const rgba_t c_YellowGreen;
extern const rgba_t c_forest_green;
extern const rgba_t c_ForestGreen;
extern const rgba_t c_olive_drab;
extern const rgba_t c_OliveDrab;
extern const rgba_t c_dark_khaki;
extern const rgba_t c_DarkKhaki;
extern const rgba_t c_khaki;
extern const rgba_t c_pale_goldenrod;
extern const rgba_t c_PaleGoldenrod;
extern const rgba_t c_light_goldenrod_yellow;
extern const rgba_t c_LightGoldenrodYellow;
extern const rgba_t c_light_yellow;
extern const rgba_t c_LightYellow;
extern const rgba_t c_yellow;
extern const rgba_t c_gold;
extern const rgba_t c_light_goldenrod;
extern const rgba_t c_LightGoldenrod;
extern const rgba_t c_goldenrod;
extern const rgba_t c_dark_goldenrod;
extern const rgba_t c_DarkGoldenrod;
extern const rgba_t c_rosy_brown;
extern const rgba_t c_RosyBrown;
extern const rgba_t c_indian_red;
extern const rgba_t c_IndianRed;
extern const rgba_t c_saddle_brown;
extern const rgba_t c_SaddleBrown;
extern const rgba_t c_sienna;
extern const rgba_t c_peru;
extern const rgba_t c_burlywood;
extern const rgba_t c_beige;
extern const rgba_t c_wheat;
extern const rgba_t c_sandy_brown;
extern const rgba_t c_SandyBrown;
extern const rgba_t c_tan;
extern const rgba_t c_chocolate;
extern const rgba_t c_firebrick;
extern const rgba_t c_brown;
extern const rgba_t c_dark_salmon;
extern const rgba_t c_DarkSalmon;
extern const rgba_t c_salmon;
extern const rgba_t c_light_salmon;
extern const rgba_t c_LightSalmon;
extern const rgba_t c_orange;
extern const rgba_t c_dark_orange;
extern const rgba_t c_DarkOrange;
extern const rgba_t c_coral;
extern const rgba_t c_light_coral;
extern const rgba_t c_LightCoral;
extern const rgba_t c_tomato;
extern const rgba_t c_orange_red;
extern const rgba_t c_OrangeRed;
extern const rgba_t c_red;
extern const rgba_t c_hot_pink;
extern const rgba_t c_HotPink;
extern const rgba_t c_deep_pink;
extern const rgba_t c_DeepPink;
extern const rgba_t c_pink;
extern const rgba_t c_light_pink;
extern const rgba_t c_LightPink;
extern const rgba_t c_pale_violet_red;
extern const rgba_t c_PaleVioletRed;
extern const rgba_t c_maroon;
extern const rgba_t c_medium_violet_red;
extern const rgba_t c_MediumVioletRed;
extern const rgba_t c_violet_red;
extern const rgba_t c_VioletRed;
extern const rgba_t c_magenta;
extern const rgba_t c_violet;
extern const rgba_t c_plum;
extern const rgba_t c_orchid;
extern const rgba_t c_medium_orchid;
extern const rgba_t c_MediumOrchid;
extern const rgba_t c_dark_orchid;
extern const rgba_t c_DarkOrchid;
extern const rgba_t c_dark_violet;
extern const rgba_t c_DarkViolet;
extern const rgba_t c_blue_violet;
extern const rgba_t c_BlueViolet;
extern const rgba_t c_purple;
extern const rgba_t c_medium_purple;
extern const rgba_t c_MediumPurple;
extern const rgba_t c_thistle;
extern const rgba_t c_snow1;
extern const rgba_t c_snow2;
extern const rgba_t c_snow3;
extern const rgba_t c_snow4;
extern const rgba_t c_seashell1;
extern const rgba_t c_seashell2;
extern const rgba_t c_seashell3;
extern const rgba_t c_seashell4;
extern const rgba_t c_AntiqueWhite1;
extern const rgba_t c_AntiqueWhite2;
extern const rgba_t c_AntiqueWhite3;
extern const rgba_t c_AntiqueWhite4;
extern const rgba_t c_bisque1;
extern const rgba_t c_bisque2;
extern const rgba_t c_bisque3;
extern const rgba_t c_bisque4;
extern const rgba_t c_PeachPuff1;
extern const rgba_t c_PeachPuff2;
extern const rgba_t c_PeachPuff3;
extern const rgba_t c_PeachPuff4;
extern const rgba_t c_NavajoWhite1;
extern const rgba_t c_NavajoWhite2;
extern const rgba_t c_NavajoWhite3;
extern const rgba_t c_NavajoWhite4;
extern const rgba_t c_LemonChiffon1;
extern const rgba_t c_LemonChiffon2;
extern const rgba_t c_LemonChiffon3;
extern const rgba_t c_LemonChiffon4;
extern const rgba_t c_cornsilk1;
extern const rgba_t c_cornsilk2;
extern const rgba_t c_cornsilk3;
extern const rgba_t c_cornsilk4;
extern const rgba_t c_ivory1;
extern const rgba_t c_ivory2;
extern const rgba_t c_ivory3;
extern const rgba_t c_ivory4;
extern const rgba_t c_honeydew1;
extern const rgba_t c_honeydew2;
extern const rgba_t c_honeydew3;
extern const rgba_t c_honeydew4;
extern const rgba_t c_LavenderBlush1;
extern const rgba_t c_LavenderBlush2;
extern const rgba_t c_LavenderBlush3;
extern const rgba_t c_LavenderBlush4;
extern const rgba_t c_MistyRose1;
extern const rgba_t c_MistyRose2;
extern const rgba_t c_MistyRose3;
extern const rgba_t c_MistyRose4;
extern const rgba_t c_azure1;
extern const rgba_t c_azure2;
extern const rgba_t c_azure3;
extern const rgba_t c_azure4;
extern const rgba_t c_SlateBlue1;
extern const rgba_t c_SlateBlue2;
extern const rgba_t c_SlateBlue3;
extern const rgba_t c_SlateBlue4;
extern const rgba_t c_RoyalBlue1;
extern const rgba_t c_RoyalBlue2;
extern const rgba_t c_RoyalBlue3;
extern const rgba_t c_RoyalBlue4;
extern const rgba_t c_blue1;
extern const rgba_t c_blue2;
extern const rgba_t c_blue3;
extern const rgba_t c_blue4;
extern const rgba_t c_DodgerBlue1;
extern const rgba_t c_DodgerBlue2;
extern const rgba_t c_DodgerBlue3;
extern const rgba_t c_DodgerBlue4;
extern const rgba_t c_SteelBlue1;
extern const rgba_t c_SteelBlue2;
extern const rgba_t c_SteelBlue3;
extern const rgba_t c_SteelBlue4;
extern const rgba_t c_DeepSkyBlue1;
extern const rgba_t c_DeepSkyBlue2;
extern const rgba_t c_DeepSkyBlue3;
extern const rgba_t c_DeepSkyBlue4;
extern const rgba_t c_SkyBlue1;
extern const rgba_t c_SkyBlue2;
extern const rgba_t c_SkyBlue3;
extern const rgba_t c_SkyBlue4;
extern const rgba_t c_LightSkyBlue1;
extern const rgba_t c_LightSkyBlue2;
extern const rgba_t c_LightSkyBlue3;
extern const rgba_t c_LightSkyBlue4;
extern const rgba_t c_SlateGray1;
extern const rgba_t c_SlateGray2;
extern const rgba_t c_SlateGray3;
extern const rgba_t c_SlateGray4;
extern const rgba_t c_LightSteelBlue1;
extern const rgba_t c_LightSteelBlue2;
extern const rgba_t c_LightSteelBlue3;
extern const rgba_t c_LightSteelBlue4;
extern const rgba_t c_LightBlue1;
extern const rgba_t c_LightBlue2;
extern const rgba_t c_LightBlue3;
extern const rgba_t c_LightBlue4;
extern const rgba_t c_LightCyan1;
extern const rgba_t c_LightCyan2;
extern const rgba_t c_LightCyan3;
extern const rgba_t c_LightCyan4;
extern const rgba_t c_PaleTurquoise1;
extern const rgba_t c_PaleTurquoise2;
extern const rgba_t c_PaleTurquoise3;
extern const rgba_t c_PaleTurquoise4;
extern const rgba_t c_CadetBlue1;
extern const rgba_t c_CadetBlue2;
extern const rgba_t c_CadetBlue3;
extern const rgba_t c_CadetBlue4;
extern const rgba_t c_turquoise1;
extern const rgba_t c_turquoise2;
extern const rgba_t c_turquoise3;
extern const rgba_t c_turquoise4;
extern const rgba_t c_cyan1;
extern const rgba_t c_cyan2;
extern const rgba_t c_cyan3;
extern const rgba_t c_cyan4;
extern const rgba_t c_DarkSlateGray1;
extern const rgba_t c_DarkSlateGray2;
extern const rgba_t c_DarkSlateGray3;
extern const rgba_t c_DarkSlateGray4;
extern const rgba_t c_aquamarine1;
extern const rgba_t c_aquamarine2;
extern const rgba_t c_aquamarine3;
extern const rgba_t c_aquamarine4;
extern const rgba_t c_DarkSeaGreen1;
extern const rgba_t c_DarkSeaGreen2;
extern const rgba_t c_DarkSeaGreen3;
extern const rgba_t c_DarkSeaGreen4;
extern const rgba_t c_SeaGreen1;
extern const rgba_t c_SeaGreen2;
extern const rgba_t c_SeaGreen3;
extern const rgba_t c_SeaGreen4;
extern const rgba_t c_PaleGreen1;
extern const rgba_t c_PaleGreen2;
extern const rgba_t c_PaleGreen3;
extern const rgba_t c_PaleGreen4;
extern const rgba_t c_SpringGreen1;
extern const rgba_t c_SpringGreen2;
extern const rgba_t c_SpringGreen3;
extern const rgba_t c_SpringGreen4;
extern const rgba_t c_green1;
extern const rgba_t c_green2;
extern const rgba_t c_green3;
extern const rgba_t c_green4;
extern const rgba_t c_chartreuse1;
extern const rgba_t c_chartreuse2;
extern const rgba_t c_chartreuse3;
extern const rgba_t c_chartreuse4;
extern const rgba_t c_OliveDrab1;
extern const rgba_t c_OliveDrab2;
extern const rgba_t c_OliveDrab3;
extern const rgba_t c_OliveDrab4;
extern const rgba_t c_DarkOliveGreen1;
extern const rgba_t c_DarkOliveGreen2;
extern const rgba_t c_DarkOliveGreen3;
extern const rgba_t c_DarkOliveGreen4;
extern const rgba_t c_khaki1;
extern const rgba_t c_khaki2;
extern const rgba_t c_khaki3;
extern const rgba_t c_khaki4;
extern const rgba_t c_LightGoldenrod1;
extern const rgba_t c_LightGoldenrod2;
extern const rgba_t c_LightGoldenrod3;
extern const rgba_t c_LightGoldenrod4;
extern const rgba_t c_LightYellow1;
extern const rgba_t c_LightYellow2;
extern const rgba_t c_LightYellow3;
extern const rgba_t c_LightYellow4;
extern const rgba_t c_yellow1;
extern const rgba_t c_yellow2;
extern const rgba_t c_yellow3;
extern const rgba_t c_yellow4;
extern const rgba_t c_gold1;
extern const rgba_t c_gold2;
extern const rgba_t c_gold3;
extern const rgba_t c_gold4;
extern const rgba_t c_goldenrod1;
extern const rgba_t c_goldenrod2;
extern const rgba_t c_goldenrod3;
extern const rgba_t c_goldenrod4;
extern const rgba_t c_DarkGoldenrod1;
extern const rgba_t c_DarkGoldenrod2;
extern const rgba_t c_DarkGoldenrod3;
extern const rgba_t c_DarkGoldenrod4;
extern const rgba_t c_RosyBrown1;
extern const rgba_t c_RosyBrown2;
extern const rgba_t c_RosyBrown3;
extern const rgba_t c_RosyBrown4;
extern const rgba_t c_IndianRed1;
extern const rgba_t c_IndianRed2;
extern const rgba_t c_IndianRed3;
extern const rgba_t c_IndianRed4;
extern const rgba_t c_sienna1;
extern const rgba_t c_sienna2;
extern const rgba_t c_sienna3;
extern const rgba_t c_sienna4;
extern const rgba_t c_burlywood1;
extern const rgba_t c_burlywood2;
extern const rgba_t c_burlywood3;
extern const rgba_t c_burlywood4;
extern const rgba_t c_wheat1;
extern const rgba_t c_wheat2;
extern const rgba_t c_wheat3;
extern const rgba_t c_wheat4;
extern const rgba_t c_tan1;
extern const rgba_t c_tan2;
extern const rgba_t c_tan3;
extern const rgba_t c_tan4;
extern const rgba_t c_chocolate1;
extern const rgba_t c_chocolate2;
extern const rgba_t c_chocolate3;
extern const rgba_t c_chocolate4;
extern const rgba_t c_firebrick1;
extern const rgba_t c_firebrick2;
extern const rgba_t c_firebrick3;
extern const rgba_t c_firebrick4;
extern const rgba_t c_brown1;
extern const rgba_t c_brown2;
extern const rgba_t c_brown3;
extern const rgba_t c_brown4;
extern const rgba_t c_salmon1;
extern const rgba_t c_salmon2;
extern const rgba_t c_salmon3;
extern const rgba_t c_salmon4;
extern const rgba_t c_LightSalmon1;
extern const rgba_t c_LightSalmon2;
extern const rgba_t c_LightSalmon3;
extern const rgba_t c_LightSalmon4;
extern const rgba_t c_orange1;
extern const rgba_t c_orange2;
extern const rgba_t c_orange3;
extern const rgba_t c_orange4;
extern const rgba_t c_DarkOrange1;
extern const rgba_t c_DarkOrange2;
extern const rgba_t c_DarkOrange3;
extern const rgba_t c_DarkOrange4;
extern const rgba_t c_coral1;
extern const rgba_t c_coral2;
extern const rgba_t c_coral3;
extern const rgba_t c_coral4;
extern const rgba_t c_tomato1;
extern const rgba_t c_tomato2;
extern const rgba_t c_tomato3;
extern const rgba_t c_tomato4;
extern const rgba_t c_OrangeRed1;
extern const rgba_t c_OrangeRed2;
extern const rgba_t c_OrangeRed3;
extern const rgba_t c_OrangeRed4;
extern const rgba_t c_red1;
extern const rgba_t c_red2;
extern const rgba_t c_red3;
extern const rgba_t c_red4;
extern const rgba_t c_DeepPink1;
extern const rgba_t c_DeepPink2;
extern const rgba_t c_DeepPink3;
extern const rgba_t c_DeepPink4;
extern const rgba_t c_HotPink1;
extern const rgba_t c_HotPink2;
extern const rgba_t c_HotPink3;
extern const rgba_t c_HotPink4;
extern const rgba_t c_pink1;
extern const rgba_t c_pink2;
extern const rgba_t c_pink3;
extern const rgba_t c_pink4;
extern const rgba_t c_LightPink1;
extern const rgba_t c_LightPink2;
extern const rgba_t c_LightPink3;
extern const rgba_t c_LightPink4;
extern const rgba_t c_PaleVioletRed1;
extern const rgba_t c_PaleVioletRed2;
extern const rgba_t c_PaleVioletRed3;
extern const rgba_t c_PaleVioletRed4;
extern const rgba_t c_maroon1;
extern const rgba_t c_maroon2;
extern const rgba_t c_maroon3;
extern const rgba_t c_maroon4;
extern const rgba_t c_VioletRed1;
extern const rgba_t c_VioletRed2;
extern const rgba_t c_VioletRed3;
extern const rgba_t c_VioletRed4;
extern const rgba_t c_magenta1;
extern const rgba_t c_magenta2;
extern const rgba_t c_magenta3;
extern const rgba_t c_magenta4;
extern const rgba_t c_orchid1;
extern const rgba_t c_orchid2;
extern const rgba_t c_orchid3;
extern const rgba_t c_orchid4;
extern const rgba_t c_plum1;
extern const rgba_t c_plum2;
extern const rgba_t c_plum3;
extern const rgba_t c_plum4;
extern const rgba_t c_MediumOrchid1;
extern const rgba_t c_MediumOrchid2;
extern const rgba_t c_MediumOrchid3;
extern const rgba_t c_MediumOrchid4;
extern const rgba_t c_DarkOrchid1;
extern const rgba_t c_DarkOrchid2;
extern const rgba_t c_DarkOrchid3;
extern const rgba_t c_DarkOrchid4;
extern const rgba_t c_purple1;
extern const rgba_t c_purple2;
extern const rgba_t c_purple3;
extern const rgba_t c_purple4;
extern const rgba_t c_MediumPurple1;
extern const rgba_t c_MediumPurple2;
extern const rgba_t c_MediumPurple3;
extern const rgba_t c_MediumPurple4;
extern const rgba_t c_thistle1;
extern const rgba_t c_thistle2;
extern const rgba_t c_thistle3;
extern const rgba_t c_thistle4;
extern const rgba_t c_gray0;
extern const rgba_t c_grey0;
extern const rgba_t c_gray1;
extern const rgba_t c_grey1;
extern const rgba_t c_gray2;
extern const rgba_t c_grey2;
extern const rgba_t c_gray3;
extern const rgba_t c_grey3;
extern const rgba_t c_gray4;
extern const rgba_t c_grey4;
extern const rgba_t c_gray5;
extern const rgba_t c_grey5;
extern const rgba_t c_gray6;
extern const rgba_t c_grey6;
extern const rgba_t c_gray7;
extern const rgba_t c_grey7;
extern const rgba_t c_gray8;
extern const rgba_t c_grey8;
extern const rgba_t c_gray9;
extern const rgba_t c_grey9;
extern const rgba_t c_gray10;
extern const rgba_t c_grey10;
extern const rgba_t c_gray11;
extern const rgba_t c_grey11;
extern const rgba_t c_gray12;
extern const rgba_t c_grey12;
extern const rgba_t c_gray13;
extern const rgba_t c_grey13;
extern const rgba_t c_gray14;
extern const rgba_t c_grey14;
extern const rgba_t c_gray15;
extern const rgba_t c_grey15;
extern const rgba_t c_gray16;
extern const rgba_t c_grey16;
extern const rgba_t c_gray17;
extern const rgba_t c_grey17;
extern const rgba_t c_gray18;
extern const rgba_t c_grey18;
extern const rgba_t c_gray19;
extern const rgba_t c_grey19;
extern const rgba_t c_gray20;
extern const rgba_t c_grey20;
extern const rgba_t c_gray21;
extern const rgba_t c_grey21;
extern const rgba_t c_gray22;
extern const rgba_t c_grey22;
extern const rgba_t c_gray23;
extern const rgba_t c_grey23;
extern const rgba_t c_gray24;
extern const rgba_t c_grey24;
extern const rgba_t c_gray25;
extern const rgba_t c_grey25;
extern const rgba_t c_gray26;
extern const rgba_t c_grey26;
extern const rgba_t c_gray27;
extern const rgba_t c_grey27;
extern const rgba_t c_gray28;
extern const rgba_t c_grey28;
extern const rgba_t c_gray29;
extern const rgba_t c_grey29;
extern const rgba_t c_gray30;
extern const rgba_t c_grey30;
extern const rgba_t c_gray31;
extern const rgba_t c_grey31;
extern const rgba_t c_gray32;
extern const rgba_t c_grey32;
extern const rgba_t c_gray33;
extern const rgba_t c_grey33;
extern const rgba_t c_gray34;
extern const rgba_t c_grey34;
extern const rgba_t c_gray35;
extern const rgba_t c_grey35;
extern const rgba_t c_gray36;
extern const rgba_t c_grey36;
extern const rgba_t c_gray37;
extern const rgba_t c_grey37;
extern const rgba_t c_gray38;
extern const rgba_t c_grey38;
extern const rgba_t c_gray39;
extern const rgba_t c_grey39;
extern const rgba_t c_gray40;
extern const rgba_t c_grey40;
extern const rgba_t c_gray41;
extern const rgba_t c_grey41;
extern const rgba_t c_gray42;
extern const rgba_t c_grey42;
extern const rgba_t c_gray43;
extern const rgba_t c_grey43;
extern const rgba_t c_gray44;
extern const rgba_t c_grey44;
extern const rgba_t c_gray45;
extern const rgba_t c_grey45;
extern const rgba_t c_gray46;
extern const rgba_t c_grey46;
extern const rgba_t c_gray47;
extern const rgba_t c_grey47;
extern const rgba_t c_gray48;
extern const rgba_t c_grey48;
extern const rgba_t c_gray49;
extern const rgba_t c_grey49;
extern const rgba_t c_gray50;
extern const rgba_t c_grey50;
extern const rgba_t c_gray51;
extern const rgba_t c_grey51;
extern const rgba_t c_gray52;
extern const rgba_t c_grey52;
extern const rgba_t c_gray53;
extern const rgba_t c_grey53;
extern const rgba_t c_gray54;
extern const rgba_t c_grey54;
extern const rgba_t c_gray55;
extern const rgba_t c_grey55;
extern const rgba_t c_gray56;
extern const rgba_t c_grey56;
extern const rgba_t c_gray57;
extern const rgba_t c_grey57;
extern const rgba_t c_gray58;
extern const rgba_t c_grey58;
extern const rgba_t c_gray59;
extern const rgba_t c_grey59;
extern const rgba_t c_gray60;
extern const rgba_t c_grey60;
extern const rgba_t c_gray61;
extern const rgba_t c_grey61;
extern const rgba_t c_gray62;
extern const rgba_t c_grey62;
extern const rgba_t c_gray63;
extern const rgba_t c_grey63;
extern const rgba_t c_gray64;
extern const rgba_t c_grey64;
extern const rgba_t c_gray65;
extern const rgba_t c_grey65;
extern const rgba_t c_gray66;
extern const rgba_t c_grey66;
extern const rgba_t c_gray67;
extern const rgba_t c_grey67;
extern const rgba_t c_gray68;
extern const rgba_t c_grey68;
extern const rgba_t c_gray69;
extern const rgba_t c_grey69;
extern const rgba_t c_gray70;
extern const rgba_t c_grey70;
extern const rgba_t c_gray71;
extern const rgba_t c_grey71;
extern const rgba_t c_gray72;
extern const rgba_t c_grey72;
extern const rgba_t c_gray73;
extern const rgba_t c_grey73;
extern const rgba_t c_gray74;
extern const rgba_t c_grey74;
extern const rgba_t c_gray75;
extern const rgba_t c_grey75;
extern const rgba_t c_gray76;
extern const rgba_t c_grey76;
extern const rgba_t c_gray77;
extern const rgba_t c_grey77;
extern const rgba_t c_gray78;
extern const rgba_t c_grey78;
extern const rgba_t c_gray79;
extern const rgba_t c_grey79;
extern const rgba_t c_gray80;
extern const rgba_t c_grey80;
extern const rgba_t c_gray81;
extern const rgba_t c_grey81;
extern const rgba_t c_gray82;
extern const rgba_t c_grey82;
extern const rgba_t c_gray83;
extern const rgba_t c_grey83;
extern const rgba_t c_gray84;
extern const rgba_t c_grey84;
extern const rgba_t c_gray85;
extern const rgba_t c_grey85;
extern const rgba_t c_gray86;
extern const rgba_t c_grey86;
extern const rgba_t c_gray87;
extern const rgba_t c_grey87;
extern const rgba_t c_gray88;
extern const rgba_t c_grey88;
extern const rgba_t c_gray89;
extern const rgba_t c_grey89;
extern const rgba_t c_gray90;
extern const rgba_t c_grey90;
extern const rgba_t c_gray91;
extern const rgba_t c_grey91;
extern const rgba_t c_gray92;
extern const rgba_t c_grey92;
extern const rgba_t c_gray93;
extern const rgba_t c_grey93;
extern const rgba_t c_gray94;
extern const rgba_t c_grey94;
extern const rgba_t c_gray95;
extern const rgba_t c_grey95;
extern const rgba_t c_gray96;
extern const rgba_t c_grey96;
extern const rgba_t c_gray97;
extern const rgba_t c_grey97;
extern const rgba_t c_gray98;
extern const rgba_t c_grey98;
extern const rgba_t c_gray99;
extern const rgba_t c_grey99;
extern const rgba_t c_gray100;
extern const rgba_t c_grey100;
extern const rgba_t c_dark_grey;
extern const rgba_t c_DarkGrey;
extern const rgba_t c_dark_gray;
extern const rgba_t c_DarkGray;
extern const rgba_t c_dark_blue;
extern const rgba_t c_DarkBlue;
extern const rgba_t c_dark_cyan;
extern const rgba_t c_DarkCyan;
extern const rgba_t c_dark_magenta;
extern const rgba_t c_DarkMagenta;
extern const rgba_t c_dark_red;
extern const rgba_t c_DarkRed;
extern const rgba_t c_light_green;
extern const rgba_t c_LightGreen;

